/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShapeSecureBootOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="allowedValues")
    private final List<Boolean> allowedValues;
    @JsonProperty(value="isDefaultEnabled")
    private final Boolean isDefaultEnabled;

    @Deprecated
    @ConstructorProperties(value={"allowedValues", "isDefaultEnabled"})
    public ShapeSecureBootOptions(List<Boolean> allowedValues, Boolean isDefaultEnabled) {
        this.allowedValues = allowedValues;
        this.isDefaultEnabled = isDefaultEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Boolean> getAllowedValues() {
        return this.allowedValues;
    }

    public Boolean getIsDefaultEnabled() {
        return this.isDefaultEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShapeSecureBootOptions(");
        sb.append("super=").append(super.toString());
        sb.append("allowedValues=").append(String.valueOf(this.allowedValues));
        sb.append(", isDefaultEnabled=").append(String.valueOf(this.isDefaultEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeSecureBootOptions)) {
            return false;
        }
        ShapeSecureBootOptions other = (ShapeSecureBootOptions)((Object)o);
        return Objects.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.isDefaultEnabled, other.isDefaultEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowedValues == null ? 43 : this.allowedValues.hashCode());
        result = result * 59 + (this.isDefaultEnabled == null ? 43 : this.isDefaultEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allowedValues")
        private List<Boolean> allowedValues;
        @JsonProperty(value="isDefaultEnabled")
        private Boolean isDefaultEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allowedValues(List<Boolean> allowedValues) {
            this.allowedValues = allowedValues;
            this.__explicitlySet__.add("allowedValues");
            return this;
        }

        public Builder isDefaultEnabled(Boolean isDefaultEnabled) {
            this.isDefaultEnabled = isDefaultEnabled;
            this.__explicitlySet__.add("isDefaultEnabled");
            return this;
        }

        public ShapeSecureBootOptions build() {
            ShapeSecureBootOptions model = new ShapeSecureBootOptions(this.allowedValues, this.isDefaultEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShapeSecureBootOptions model) {
            if (model.wasPropertyExplicitlySet("allowedValues")) {
                this.allowedValues(model.getAllowedValues());
            }
            if (model.wasPropertyExplicitlySet("isDefaultEnabled")) {
                this.isDefaultEnabled(model.getIsDefaultEnabled());
            }
            return this;
        }
    }
}

