/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.LaunchInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class LaunchInstanceRequest
extends BmcRequest<LaunchInstanceDetails> {
    private LaunchInstanceDetails launchInstanceDetails;
    private String opcRetryToken;

    public LaunchInstanceDetails getLaunchInstanceDetails() {
        return this.launchInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public LaunchInstanceDetails getBody$() {
        return this.launchInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().launchInstanceDetails(this.launchInstanceDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",launchInstanceDetails=").append(String.valueOf((Object)this.launchInstanceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LaunchInstanceRequest)) {
            return false;
        }
        LaunchInstanceRequest other = (LaunchInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.launchInstanceDetails, (Object)other.launchInstanceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.launchInstanceDetails == null ? 43 : this.launchInstanceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<LaunchInstanceRequest, LaunchInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private LaunchInstanceDetails launchInstanceDetails = null;
        private String opcRetryToken = null;

        public Builder launchInstanceDetails(LaunchInstanceDetails launchInstanceDetails) {
            this.launchInstanceDetails = launchInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchInstanceRequest o) {
            this.launchInstanceDetails(o.getLaunchInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchInstanceRequest build() {
            LaunchInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LaunchInstanceDetails body) {
            this.launchInstanceDetails(body);
            return this;
        }

        public LaunchInstanceRequest buildWithoutInvocationCallback() {
            LaunchInstanceRequest request = new LaunchInstanceRequest();
            request.launchInstanceDetails = this.launchInstanceDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

