/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.customizer;

import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerJar;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.j2ee.clientproject.wsclient.CustomizerWSClientHost;
import org.netbeans.modules.j2ee.clientproject.wsclient.NoWebServiceClientsPanel;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AppClientCompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String BUILD = "Build";
    private static final String JAR = "Jar";
    private static final String JAVADOC = "Javadoc";
    public static final String RUN = "Run";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";
    private static final String WEBSERVICESCATEGORY = "WebServicesCategory";
    private static final String LICENSE = "License";
    private String name;

    public AppClientCompositePanelProvider(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])null);
        } else if (LIBRARIES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, (ProjectCustomizer.Category[])null);
        } else if (BUILD.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, (ProjectCustomizer.Category[])null);
        } else if (JAR.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)JAR, (String)bundle.getString("LBL_Config_Jar"), null, (ProjectCustomizer.Category[])null);
        } else if (JAVADOC.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)JAVADOC, (String)bundle.getString("LBL_Config_Javadoc"), null, (ProjectCustomizer.Category[])null);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])null);
        } else if (WEBSERVICESCATEGORY.equals(this.name)) {
            AppClientProject project = (AppClientProject)context.lookup(AppClientProject.class);
            List serviceClientsSettings = null;
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)project.getProjectDirectory());
            if (clientSupport != null) {
                serviceClientsSettings = clientSupport.getServiceClients();
            }
            if (Profile.J2EE_14.equals((Object)project.getCarModule().getJ2eeProfile()) && serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
                ProjectCustomizer.Category clients = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)bundle.getString("LBL_Config_WebServiceClients"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
                toReturn = ProjectCustomizer.Category.create((String)WEBSERVICESCATEGORY, (String)bundle.getString("LBL_Config_WebServiceCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{clients});
            }
        } else if (LICENSE.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LICENSE, (String)bundle.getString("LBL_Config_License"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        String nm = category.getName();
        AppClientProjectProperties uiProps = (AppClientProjectProperties)context.lookup(AppClientProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(uiProps);
        }
        if (LIBRARIES.equals(nm)) {
            CustomizerProviderImpl.SubCategoryProvider prov = (CustomizerProviderImpl.SubCategoryProvider)context.lookup(CustomizerProviderImpl.SubCategoryProvider.class);
            assert (prov != null) : "Assuming CustomizerProviderImpl.SubCategoryProvider in customizer context";
            return new CustomizerLibraries(uiProps, prov);
        }
        if (BUILD.equals(nm)) {
            return new CustomizerCompile(uiProps);
        }
        if (JAR.equals(nm)) {
            return new CustomizerJar(uiProps);
        }
        if (JAVADOC.equals(nm)) {
            return new CustomizerJavadoc(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps);
        }
        if (WEBSERVICECLIENTS.equals(nm)) {
            List serviceClientsSettings = null;
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)uiProps.getProject().getProjectDirectory());
            if (clientSupport != null) {
                serviceClientsSettings = clientSupport.getServiceClients();
            }
            if (serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
                return new CustomizerWSClientHost(uiProps, serviceClientsSettings);
            }
            return new NoWebServiceClientsPanel();
        }
        if (LICENSE.equals(nm)) {
            return CustomizerUtilities.createLicenseHeaderCustomizerPanel((ProjectCustomizer.Category)category, (CustomizerUtilities.LicensePanelContentHandler)uiProps.LICENSE_SUPPORT);
        }
        return new JPanel();
    }

    public static AppClientCompositePanelProvider createSources() {
        return new AppClientCompositePanelProvider(SOURCES);
    }

    public static AppClientCompositePanelProvider createLibraries() {
        return new AppClientCompositePanelProvider(LIBRARIES);
    }

    public static AppClientCompositePanelProvider createBuild() {
        return new AppClientCompositePanelProvider(BUILD);
    }

    public static AppClientCompositePanelProvider createJar() {
        return new AppClientCompositePanelProvider(JAR);
    }

    public static AppClientCompositePanelProvider createJavadoc() {
        return new AppClientCompositePanelProvider(JAVADOC);
    }

    public static AppClientCompositePanelProvider createRun() {
        return new AppClientCompositePanelProvider(RUN);
    }

    public static AppClientCompositePanelProvider createWebServicesCategory() {
        return new AppClientCompositePanelProvider(WEBSERVICESCATEGORY);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createLicense() {
        return new AppClientCompositePanelProvider(LICENSE);
    }
}

