/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskContainerNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class CategoryNode
extends TaskContainerNode
implements Comparable<CategoryNode> {
    private final Category category;
    private JPanel panel;
    private TreeLabel lblName;
    private LinkButton btnRefresh;
    private Actions.CloseCategoryNodeAction closeCategoryAction;
    private Actions.OpenCategoryNodeAction openCategoryAction;
    private TreeLabel lblTotal;
    private TreeLabel lblChanged;
    final Object LOCK = new Object();
    private TreeLabel lblSeparator;
    private static final ImageIcon CATEGORY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/category.png", (boolean)true);

    public CategoryNode(Category category, boolean refresh) {
        this(category, true, refresh);
    }

    public CategoryNode(Category category, boolean opened, boolean refresh) {
        super(refresh, opened, null, category.getName(), CATEGORY_ICON);
        this.category = category;
    }

    @Override
    void refreshTaskContainer() {
        this.category.refresh();
    }

    @Override
    public List<IssueImpl> getTasks(boolean includingNodeItself) {
        List<IssueImpl> tasks = Collections.emptyList();
        try {
            tasks = new ArrayList<IssueImpl>(this.category.getTasks());
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        return tasks;
    }

    @Override
    void adjustTaskNode(TaskNode taskNode) {
        taskNode.setCategory(this.category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateCounts() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.panel != null) {
                int count = this.getChangedTaskCount();
                this.lblTotal.setText(this.getTotalString());
                this.lblChanged.setText(this.getChangedString(count));
                boolean showChanged = count > 0;
                this.lblSeparator.setVisible(showChanged);
                this.lblChanged.setVisible(showChanged);
            }
        }
    }

    @Override
    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        super.configure(component, foreground, background, isSelected, hasFocus, rowWidth);
        if (this.panel != null) {
            if (DashboardViewer.getInstance().containsActiveTask((TreeListNode)this)) {
                this.lblName.setFont(this.lblName.getFont().deriveFont(1));
            } else {
                this.lblName.setFont(this.lblName.getFont().deriveFont(0));
            }
            this.lblName.setText(DashboardUtils.getCategoryDisplayText(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent createComponent(List<IssueImpl> data) {
        if (this.isError()) {
            this.setError(false);
            return null;
        }
        this.updateNodes(data);
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            JLabel iconLabel = new JLabel(this.getIcon());
            this.panel.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.lblName = new TreeLabel(DashboardUtils.getCategoryDisplayText(this));
            this.panel.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.labels.add(this.lblName);
            TreeLabel lbl = new TreeLabel("(");
            this.labels.add(lbl);
            this.panel.add((Component)lbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.lblTotal = new TreeLabel(this.getTotalString());
            this.panel.add((Component)this.lblTotal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labels.add(this.lblTotal);
            int count = this.getChangedTaskCount();
            boolean showChanged = count > 0;
            this.lblSeparator = new TreeLabel("|");
            this.lblSeparator.setVisible(showChanged);
            this.panel.add((Component)this.lblSeparator, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.labels.add(this.lblSeparator);
            this.lblChanged = new TreeLabel(this.getChangedString(count));
            this.lblChanged.setVisible(showChanged);
            this.panel.add((Component)this.lblChanged, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labels.add(this.lblChanged);
            lbl = new TreeLabel(")");
            this.labels.add(lbl);
            this.panel.add((Component)lbl, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnRefresh = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/refresh.png", (boolean)true), (Action)Actions.RefreshAction.createAction(new TreeListNode[]{this}));
            this.btnRefresh.setToolTipText(NbBundle.getMessage(CategoryNode.class, (String)"LBL_Refresh"));
            this.panel.add((Component)this.btnRefresh, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
        }
        return this.panel;
    }

    List<Action> getCategoryActions(List<TreeListNode> selectedNodes) {
        boolean justCategories = true;
        ArrayList<Action> actions = new ArrayList<Action>();
        CategoryNode[] categoryNodes = new CategoryNode[selectedNodes.size()];
        for (int i = 0; i < selectedNodes.size(); ++i) {
            TreeListNode treeListNode = selectedNodes.get(i);
            if (!(treeListNode instanceof CategoryNode)) {
                justCategories = false;
                break;
            }
            categoryNodes[i] = (CategoryNode)treeListNode;
        }
        if (justCategories) {
            actions.addAll(Actions.getCategoryPopupActions(categoryNodes));
            Action categoryAction = this.getOpenCloseAction(categoryNodes);
            if (categoryAction != null) {
                actions.add(null);
                actions.add(categoryAction);
            }
        }
        return actions;
    }

    private Action getOpenCloseAction(CategoryNode ... categoryNodes) {
        boolean allOpened = true;
        boolean allClosed = true;
        for (CategoryNode categoryNode : categoryNodes) {
            if (categoryNode.isOpened()) {
                allClosed = false;
                continue;
            }
            allOpened = false;
        }
        if (allOpened) {
            if (this.closeCategoryAction == null) {
                this.closeCategoryAction = new Actions.CloseCategoryNodeAction(categoryNodes);
            }
            return this.closeCategoryAction;
        }
        if (allClosed) {
            if (this.openCategoryAction == null) {
                this.openCategoryAction = new Actions.OpenCategoryNodeAction(categoryNodes);
            }
            return this.openCategoryAction;
        }
        return null;
    }

    public final Category getCategory() {
        return this.category;
    }

    public boolean isOpened() {
        return true;
    }

    public final Action[] getPopupActions() {
        List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
        ArrayList<Action> actions = new ArrayList<Action>(this.getCategoryActions(selectedNodes));
        actions.add(null);
        actions.addAll(Actions.getDefaultActions(selectedNodes.toArray(new TreeListNode[0])));
        return actions.toArray(new Action[0]);
    }

    public boolean addTaskNode(TaskNode taskNode, boolean isInFilter) {
        if (this.getTaskNodes().contains(taskNode)) {
            return false;
        }
        this.getTaskNodes().add(taskNode);
        this.category.addTask(taskNode.getTask());
        if (isInFilter) {
            this.getFilteredTaskNodes().add(taskNode);
        }
        return true;
    }

    public void removeTaskNode(TaskNode taskNode) {
        this.getTaskNodes().remove(taskNode);
        this.category.removeTask(taskNode.getTask());
        this.getFilteredTaskNodes().remove(taskNode);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryNode other = (CategoryNode)obj;
        return this.category.equals(other.category);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.category != null ? this.category.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(CategoryNode toCompare) {
        if (this.isOpened() != toCompare.isOpened()) {
            return this.isOpened() ? -1 : 1;
        }
        if (this.category.persist() != toCompare.category.persist()) {
            return this.category.persist() ? -1 : 1;
        }
        int sortIndexCompare = Integer.compare(this.category.sortIndex(), toCompare.category.sortIndex());
        if (sortIndexCompare != 0) {
            return sortIndexCompare;
        }
        return this.category.getName().compareToIgnoreCase(toCompare.getCategory().getName());
    }

    public String toString() {
        return this.category.getName();
    }

    int indexOf(IssueImpl task) {
        for (int i = 0; i < this.getTaskNodes().size(); ++i) {
            TaskNode taskNode = this.getTaskNodes().get(i);
            if (!taskNode.getTask().equals(task)) continue;
            return i;
        }
        return -1;
    }

    @Override
    ImageIcon getIcon() {
        return CATEGORY_ICON;
    }

    @Override
    boolean isTaskLimited() {
        return DashboardSettings.getInstance().isTasksLimitCategory();
    }
}

