/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.inspect.webkit.DOMNode;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.modules.web.webkit.debugging.api.dom.NodeAnnotator;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class DOMNodeAnnotator
implements NodeAnnotator.Impl {
    private static DOMNodeAnnotator INSTANCE;
    private final Map<Integer, Image> badges = new HashMap<Integer, Image>();

    public static DOMNodeAnnotator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = (DOMNodeAnnotator)Lookup.getDefault().lookup(DOMNodeAnnotator.class);
        }
        return INSTANCE;
    }

    public void annotate(Node node, Image badge) {
        WebKitPageModel pageModel;
        DOMNode domNode;
        int nodeId = node.getNodeId();
        if (badge == null) {
            this.badges.remove(nodeId);
        } else {
            this.badges.put(node.getNodeId(), badge);
        }
        Page page = PageInspector.getDefault().getPage();
        if (page instanceof WebKitPageModel && (domNode = (pageModel = (WebKitPageModel)page).getNode(node.getNodeId())) != null) {
            domNode.updateIcon();
        }
    }

    public Image annotateIcon(Node node, Image originalImage) {
        Image image = originalImage;
        Image badge = this.badges.get(node.getNodeId());
        if (badge != null) {
            int x = image.getWidth(null) - badge.getWidth(null);
            int y = image.getHeight(null) - badge.getHeight(null);
            image = ImageUtilities.mergeImages((Image)image, (Image)badge, (int)x, (int)y);
        }
        return image;
    }
}

