/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class UploadCommand
extends RemoteCommand
implements Displayable {
    public static final String ID = "upload";
    public static final String DISPLAY_NAME = NbBundle.getMessage(UploadCommand.class, (String)"LBL_UploadCommand");

    public UploadCommand(PhpProject project) {
        super(project);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    protected Runnable getContextRunnable(final Lookup context) {
        return new Runnable(){

            @Override
            public void run() {
                UploadCommand.this.invokeActionImpl(context);
            }
        };
    }

    void invokeActionImpl(Lookup context) {
        FileObject[] selectedFiles = CommandUtils.filesForContextOrSelectedNodes(context);
        if (selectedFiles.length == 0) {
            return;
        }
        this.uploadFiles(selectedFiles, null);
    }

    public void uploadFiles(FileObject[] filesToUpload, FileObject[] preselectedFiles) {
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.getProject());
        assert (sources != null);
        if (!this.sourcesFilesOnly(sources, filesToUpload)) {
            return;
        }
        InputOutput remoteLog = UploadCommand.getRemoteLog(RunConfigRemote.forProject(this.getProject()).getRemoteConfiguration().getDisplayName());
        RemoteClient remoteClient = this.getRemoteClient(remoteLog);
        Set<TransferFile> forUpload = this.prepareUpload(sources, filesToUpload, preselectedFiles, remoteClient);
        this.upload(forUpload, sources, filesToUpload, remoteLog, remoteClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TransferFile> prepareUpload(FileObject sources, FileObject[] filesToUpload, FileObject[] preselectedFiles, RemoteClient remoteClient) {
        Set<TransferFile> forUpload = Collections.emptySet();
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(UploadCommand.class, (String)"MSG_UploadingFiles", (Object)this.getProject().getName()), (Cancellable)remoteClient);
        try {
            progressHandle.start();
            forUpload = remoteClient.prepareUpload(sources, filesToUpload);
            RemoteUtils.fetchAllFiles(false, forUpload, sources, filesToUpload);
            if (preselectedFiles != null && preselectedFiles.length > 0) {
                File baseLocalDir = FileUtil.toFile((FileObject)sources);
                String baseLocalAbsolutePath = baseLocalDir.getAbsolutePath();
                block3: for (FileObject fo : preselectedFiles) {
                    TransferFile transferFile = TransferFile.fromFileObject(remoteClient.createRemoteClientImplementation(baseLocalAbsolutePath), null, fo);
                    for (TransferFile file : forUpload) {
                        if (!transferFile.equals(file)) continue;
                        file.touch();
                        continue block3;
                    }
                }
            }
            boolean showDialog = true;
            if (forUpload.size() == 1 && forUpload.iterator().next().isFile()) {
                showDialog = false;
            }
            if (showDialog) {
                forUpload = TransferFilesChooser.forUpload(forUpload, RemoteUtils.getLastTimestamp(true, this.getProject())).showDialog();
            }
        }
        finally {
            progressHandle.finish();
        }
        return forUpload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(Set<TransferFile> forUpload, FileObject sources, FileObject[] filesToUpload, InputOutput remoteLog, RemoteClient remoteClient) {
        TransferInfo transferInfo = null;
        try {
            if (forUpload.size() > 0) {
                boolean askSync = !remoteClient.listFiles(UploadCommand.getRemoteRoot(remoteClient, sources)).isEmpty();
                ProgressHandle progressHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(UploadCommand.class, (String)"MSG_UploadingFiles", (Object)this.getProject().getName()), (Cancellable)remoteClient);
                RemoteCommand.DefaultOperationMonitor uploadOperationMonitor = new RemoteCommand.DefaultOperationMonitor(progressHandle, forUpload);
                remoteClient.setOperationMonitor(uploadOperationMonitor);
                transferInfo = remoteClient.upload(forUpload);
                remoteClient.setOperationMonitor(null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UploadCommand.class, (String)"MSG_UploadFinished", (Object)this.getProject().getName()));
                if (UploadCommand.isSourcesSelected(sources, filesToUpload) && !remoteClient.isCancelled() && transferInfo.hasAnyTransfered()) {
                    PhpProject project = this.getProject();
                    UploadCommand.storeLastUpload(project);
                    UploadCommand.storeLastSync(project, remoteClient, sources, askSync);
                }
            }
        }
        catch (RemoteException ex) {
            RemoteUtils.processRemoteException(ex);
        }
        finally {
            try {
                remoteClient.disconnect(true);
            }
            catch (RemoteException ex) {
                RemoteUtils.processRemoteException(ex);
            }
            if (transferInfo != null) {
                UploadCommand.processTransferInfo(transferInfo, remoteLog);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    private static void storeLastUpload(PhpProject project) {
        ProjectSettings.setLastUpload(project, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }
}

