/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.BalancingPolicy;
import org.apache.karaf.http.core.Proxy;
import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.http.core.internal.proxy.ProxyServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceImpl
implements ProxyService {
    private static Logger LOG = LoggerFactory.getLogger((String)ProxyServiceImpl.class.getName());
    protected static final String CONFIGURATION_PID = "org.apache.karaf.http";
    protected static final String CONFIGURATION_KEY = "proxies";
    private ConfigurationAdmin configurationAdmin;
    private HttpService httpService;
    private BundleContext bundleContext;
    private Map<String, Proxy> proxies;

    public ProxyServiceImpl(HttpService httpService, ConfigurationAdmin configurationAdmin, BundleContext bundleContext) {
        this.httpService = httpService;
        this.configurationAdmin = configurationAdmin;
        this.bundleContext = bundleContext;
        this.proxies = new HashMap<String, Proxy>();
        try {
            Configuration configuration = configurationAdmin.getConfiguration(CONFIGURATION_PID, null);
            if (configuration != null) {
                this.update(configuration.getProcessedProperties(null));
            }
        }
        catch (Exception e) {
            LOG.error("Can't load proxies", (Throwable)e);
        }
    }

    @Override
    public Map<String, Proxy> getProxies() {
        return this.proxies;
    }

    @Override
    public Collection<String> getBalancingPolicies() throws Exception {
        ArrayList<String> balancingPolicies = new ArrayList<String>();
        Collection serviceReferences = this.bundleContext.getServiceReferences(BalancingPolicy.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            if (serviceReference.getProperty("type") == null) continue;
            balancingPolicies.add(serviceReference.getProperty("type").toString());
        }
        return balancingPolicies;
    }

    @Override
    public void addProxy(String url, String proxyTo, String balancingProxy) throws Exception {
        Proxy proxy = new Proxy(url, proxyTo, balancingProxy);
        this.addProxyInternal(proxy);
        this.updateConfiguration();
    }

    @Override
    public void removeProxy(String url) throws Exception {
        LOG.debug("removing proxy {}", (Object)url);
        this.httpService.unregister(url);
        this.proxies.remove(url);
        this.updateConfiguration();
    }

    @Override
    public void update(Dictionary<String, ?> properties) {
        LOG.debug("update proxies");
        if (properties == null) {
            return;
        }
        if (properties.get(CONFIGURATION_KEY) != null && properties.get(CONFIGURATION_KEY) instanceof String[]) {
            String[] proxiesArray;
            for (String proxyString : proxiesArray = (String[])properties.get(CONFIGURATION_KEY)) {
                String[] proxySplit = proxyString.split(" ");
                if (proxySplit.length == 3) {
                    String url = proxySplit[0].trim();
                    this.validateUrl(url);
                    String proxyTo = proxySplit[1].trim();
                    String balancingPolicy = proxySplit[2].trim();
                    if (this.proxies.containsKey(url)) continue;
                    if (balancingPolicy.equals("null")) {
                        balancingPolicy = null;
                    }
                    Proxy proxy = new Proxy(url, proxyTo, balancingPolicy);
                    this.addProxyInternal(proxy);
                    continue;
                }
                LOG.error("Incorrect configuration line {}", (Object)proxyString);
            }
        }
    }

    private void addProxyInternal(Proxy proxy) {
        if (proxy.getBalancingPolicy() != null) {
            LOG.debug("Adding {} proxy to {} ({})", new Object[]{proxy.getUrl(), proxy.getProxyTo(), proxy.getBalancingPolicy()});
        } else {
            LOG.debug("Adding {} proxy to {}", (Object)proxy.getUrl(), (Object)proxy.getProxyTo());
        }
        try {
            Collection serviceReferences;
            ProxyServlet proxyServlet = new ProxyServlet();
            proxyServlet.setProxyTo(proxy.getProxyTo());
            if (proxy.getBalancingPolicy() != null && (serviceReferences = this.bundleContext.getServiceReferences(BalancingPolicy.class, "(type=" + proxy.getBalancingPolicy() + ")")) != null && serviceReferences.size() == 1) {
                BalancingPolicy balancingPolicy = (BalancingPolicy)this.bundleContext.getService((ServiceReference)serviceReferences.iterator().next());
                proxyServlet.setBalancingPolicy(balancingPolicy);
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("servlet-name", this.getUniqueServletName(proxy));
            this.httpService.registerServlet(proxy.getUrl(), (Servlet)proxyServlet, props, null);
            this.proxies.put(proxy.getUrl(), proxy);
        }
        catch (Exception e) {
            LOG.error("Can't add {} proxy to {}", new Object[]{proxy.getUrl(), proxy.getProxyTo(), e});
        }
    }

    private void updateConfiguration() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(CONFIGURATION_PID);
            Hashtable<String, String[]> configurationProperties = configuration.getProcessedProperties(null);
            if (configurationProperties == null) {
                configurationProperties = new Hashtable<String, String[]>();
            }
            String[] proxyArray = new String[this.proxies.size()];
            int i = 0;
            for (Map.Entry<String, Proxy> entry : this.proxies.entrySet()) {
                proxyArray[i] = entry.getKey() + " " + entry.getValue().getProxyTo() + " " + entry.getValue().getBalancingPolicy();
                ++i;
            }
            ((Dictionary)configurationProperties).put(CONFIGURATION_KEY, proxyArray);
            configuration.update(configurationProperties);
        }
        catch (Exception e) {
            LOG.error("unable to update http proxy from configuration", (Throwable)e);
        }
    }

    private void validateUrl(String url) {
        if (url == null || !url.startsWith("/")) {
            throw new IllegalArgumentException("Proxy URL does not start with '/': " + url);
        }
    }

    private String getUniqueServletName(Proxy proxy) {
        return proxy.getUrl().substring(1);
    }
}

