/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.internal.RuleImpl;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ConditionBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.Configuration;

@NonNullByDefault
public class RuleBuilder {
    private List<Trigger> triggers;
    private List<Condition> conditions;
    private List<Action> actions;
    private Configuration configuration;
    private List<ConfigDescriptionParameter> configDescriptions;
    private @Nullable String templateUID;
    private Rule.TemplateState templateState;
    private final String uid;
    private @Nullable String name;
    private Set<String> tags;
    private @Nullable Visibility visibility;
    private @Nullable String description;

    protected RuleBuilder(Rule rule) {
        this.triggers = new LinkedList<Trigger>(rule.getTriggers());
        this.conditions = new LinkedList<Condition>(rule.getConditions());
        this.actions = new LinkedList<Action>(rule.getActions());
        this.configuration = new Configuration(rule.getConfiguration());
        this.configDescriptions = new LinkedList<ConfigDescriptionParameter>(rule.getConfigurationDescriptions());
        this.templateUID = rule.getTemplateUID();
        this.templateState = Rule.TemplateState.NO_TEMPLATE;
        this.uid = rule.getUID();
        this.name = rule.getName();
        this.tags = new HashSet<String>(rule.getTags());
        this.visibility = rule.getVisibility();
        this.description = rule.getDescription();
    }

    public static RuleBuilder create(String ruleId) {
        RuleImpl rule = new RuleImpl(ruleId);
        return new RuleBuilder(rule);
    }

    public static RuleBuilder create(Rule r) {
        return RuleBuilder.create(r.getUID()).withActions(r.getActions()).withConditions(r.getConditions()).withTriggers(r.getTriggers()).withConfiguration(r.getConfiguration()).withConfigurationDescriptions(r.getConfigurationDescriptions()).withDescription(r.getDescription()).withName(r.getName()).withTags(r.getTags()).withTemplateUID(r.getTemplateUID()).withTemplateState(r.getTemplateState());
    }

    public static RuleBuilder create(RuleTemplate template, String uid, @Nullable String name, Configuration configuration, Visibility visibility) {
        return RuleBuilder.create(uid).withActions(template.getActions()).withConditions(template.getConditions()).withTriggers(template.getTriggers()).withConfiguration(configuration).withConfigurationDescriptions(template.getConfigurationDescriptions()).withDescription(template.getDescription()).withName(name).withTags(template.getTags()).withTemplateState(Rule.TemplateState.INSTANTIATED).withTemplateUID(template.getUID());
    }

    public RuleBuilder withName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public RuleBuilder withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public RuleBuilder withTemplateUID(@Nullable String uid) {
        this.templateUID = uid;
        return this;
    }

    public RuleBuilder withTemplateState(Rule.TemplateState templateState) {
        this.templateState = templateState;
        return this;
    }

    public RuleBuilder withVisibility(@Nullable Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public RuleBuilder withTriggers(Trigger ... triggers) {
        return this.withTriggers(Arrays.asList(triggers));
    }

    public RuleBuilder withTriggers(@Nullable List<? extends Trigger> triggers) {
        if (triggers != null) {
            ArrayList<Trigger> triggerList = new ArrayList<Trigger>(triggers.size());
            triggers.forEach(t -> {
                boolean bl = triggerList.add(TriggerBuilder.create(t).build());
            });
            this.triggers = triggerList;
        }
        return this;
    }

    public RuleBuilder withConditions(Condition ... conditions) {
        return this.withConditions(Arrays.asList(conditions));
    }

    public RuleBuilder withConditions(@Nullable List<? extends Condition> conditions) {
        if (conditions != null) {
            ArrayList<Condition> conditionList = new ArrayList<Condition>(conditions.size());
            conditions.forEach(c -> {
                boolean bl = conditionList.add(ConditionBuilder.create(c).build());
            });
            this.conditions = conditionList;
        }
        return this;
    }

    public RuleBuilder withActions(Action ... actions) {
        return this.withActions(Arrays.asList(actions));
    }

    public RuleBuilder withActions(@Nullable List<? extends Action> actions) {
        if (actions != null) {
            ArrayList<Action> actionList = new ArrayList<Action>(actions.size());
            actions.forEach(a -> {
                boolean bl = actionList.add(ActionBuilder.create(a).build());
            });
            this.actions = actionList;
        }
        return this;
    }

    public RuleBuilder withTags(String ... tags) {
        this.withTags(Set.of(tags));
        return this;
    }

    public RuleBuilder withTags(@Nullable Set<String> tags) {
        this.tags = tags != null ? Set.copyOf(tags) : Set.of();
        return this;
    }

    public RuleBuilder withConfiguration(@Nullable Configuration ruleConfiguration) {
        this.configuration = new Configuration(ruleConfiguration);
        return this;
    }

    public RuleBuilder withConfigurationDescriptions(@Nullable List<ConfigDescriptionParameter> configDescs) {
        this.configDescriptions = configDescs != null ? List.copyOf(configDescs) : List.of();
        return this;
    }

    public Rule build() {
        return new RuleImpl(this.uid, this.name, this.description, this.tags, this.triggers, this.conditions, this.actions, this.configDescriptions, this.configuration, this.templateUID, this.templateState, this.visibility);
    }
}

