/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.common;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.graalvm.visualvm.lib.common.AttachSettings;
import org.graalvm.visualvm.lib.common.GlobalProfilingSettings;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.SessionSettings;
import org.graalvm.visualvm.lib.common.event.ProfilingStateEvent;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.instrumentation.BadLocationException;
import org.graalvm.visualvm.lib.jfluid.instrumentation.InstrumentationException;
import org.graalvm.visualvm.lib.jfluid.results.monitor.VMTelemetryDataManager;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadsDataManager;
import org.openide.util.Lookup;

public abstract class Profiler {
    public static final int PROFILING_INACTIVE = 1;
    public static final int PROFILING_STARTED = 2;
    public static final int PROFILING_RUNNING = 4;
    public static final int PROFILING_PAUSED = 8;
    public static final int PROFILING_STOPPED = 16;
    public static final int PROFILING_IN_TRANSITION = 128;
    public static final int MODE_ATTACH = 0;
    public static final int MODE_PROFILE = 1;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 2;
    public static final int USER = 4;
    public static final int EXCEPTION = 8;
    public static final int ERROR = 16;
    private static final boolean DEBUG = System.getProperty("org.graalvm.visualvm.lib.common.Profiler") != null;
    private static Profiler defaultProfiler;
    private Vector profilingStateListeners;
    private int currentProfilingState = 1;

    public static synchronized Profiler getDefault() {
        if (defaultProfiler == null) {
            defaultProfiler = (Profiler)Lookup.getDefault().lookup(Profiler.class);
            if (defaultProfiler == null) {
                throw new InternalError("Should never happen");
            }
            if (DEBUG) {
                System.err.println("Default Profiler succesfully installed: " + defaultProfiler);
            }
        }
        return defaultProfiler;
    }

    public abstract int getAgentState(String var1, int var2, int var3);

    public abstract SessionSettings getCurrentSessionSettings();

    public abstract GlobalProfilingSettings getGlobalProfilingSettings();

    public abstract ProfilingSettings getLastProfilingSettings();

    public abstract int getProfilingMode();

    public abstract int getProfilingState();

    public abstract int getServerState();

    public abstract int getServerProgress();

    public abstract TargetAppRunner getTargetAppRunner();

    public abstract ThreadsDataManager getThreadsManager();

    public abstract void setThreadsMonitoringEnabled(boolean var1);

    public abstract boolean getThreadsMonitoringEnabled();

    public abstract void setLockContentionMonitoringEnabled(boolean var1);

    public abstract boolean getLockContentionMonitoringEnabled();

    public abstract VMTelemetryDataManager getVMTelemetryManager();

    public abstract boolean attachToApp(ProfilingSettings var1, AttachSettings var2);

    public abstract boolean connectToStartedApp(ProfilingSettings var1, SessionSettings var2);

    public abstract void detachFromApp();

    public abstract void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] var1) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated;

    public abstract void log(int var1, String var2);

    public abstract void modifyCurrentProfiling(ProfilingSettings var1);

    public abstract void notifyException(int var1, Exception var2);

    public abstract void openJavaSource(String var1, String var2, String var3);

    public abstract boolean profileClass(ProfilingSettings var1, SessionSettings var2);

    public abstract boolean rerunAvailable();

    public abstract boolean modifyAvailable();

    public abstract void rerunLastProfiling();

    public abstract boolean runCalibration(boolean var1, String var2, String var3, int var4);

    public abstract boolean shutdownBlockedAgent(String var1, int var2, int var3);

    public abstract void stopApp();

    public final void addProfilingStateListener(ProfilingStateListener profilingStateListener) {
        if (this.profilingStateListeners == null) {
            this.profilingStateListeners = new Vector();
        }
        if (!this.profilingStateListeners.contains(profilingStateListener)) {
            this.profilingStateListeners.add(profilingStateListener);
            profilingStateListener.profilingStateChanged(new ProfilingStateEvent(-1, this.currentProfilingState, defaultProfiler));
        }
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException, BadLocationException, ClassNotFoundException, IOException, ClassFormatError {
        ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
        int oldInstrType = client.getStatus().currentInstrType;
        switch (profilingSettings.getProfilingType()) {
            case 1: {
                client.initiateMonitoring();
                break;
            }
            case 128: {
                client.initiateMemoryProfInstrumentation(7);
                break;
            }
            case 2: {
                client.initiateMemoryProfInstrumentation(5);
                break;
            }
            case 4: {
                client.initiateMemoryProfInstrumentation(6);
                break;
            }
            case 8: 
            case 16: 
            case 256: {
                this.instrumentSelectedRoots(profilingSettings.getInstrumentationMethods());
                break;
            }
            case 64: {
                client.initiateCPUSampling();
                break;
            }
            case 32: {
                ClientUtils.SourceCodeSelection[] fragment = new ClientUtils.SourceCodeSelection[]{profilingSettings.getCodeFragmentSelection()};
                client.initiateCodeRegionInstrumentation(fragment);
            }
        }
        this.fireInstrumentationChanged(oldInstrType, client.getStatus().currentInstrType);
        return true;
    }

    public final boolean profilingInProgress() {
        int state = this.getProfilingState();
        return state == 8 || state == 4;
    }

    public final void removeProfilingStateListener(ProfilingStateListener profilingStateListener) {
        if (this.profilingStateListeners != null) {
            this.profilingStateListeners.remove(profilingStateListener);
        }
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.err.println("Profiler.DEBUG: " + s);
        }
    }

    public static void debug(Exception e) {
        if (DEBUG) {
            System.err.print("Profiler.DEBUG: ");
            e.printStackTrace(System.err);
        }
    }

    public abstract String getLibsDir();

    public abstract int getPlatformArchitecture(String var1);

    public abstract String getPlatformJDKVersion(String var1);

    public abstract String getPlatformJavaFile(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireInstrumentationChanged(final int oldInstrType, final int currentInstrType) {
        Vector toNotify;
        if (this.profilingStateListeners == null) {
            return;
        }
        Profiler profiler = this;
        synchronized (profiler) {
            toNotify = (Vector)this.profilingStateListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    ((ProfilingStateListener)iterator.next()).instrumentationChanged(oldInstrType, currentInstrType);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireProfilingStateChange(int oldProfilingState, int newProfilingState) {
        Vector toNotify;
        this.currentProfilingState = newProfilingState;
        if (this.profilingStateListeners == null) {
            return;
        }
        if (oldProfilingState == newProfilingState) {
            return;
        }
        Profiler profiler = this;
        synchronized (profiler) {
            toNotify = (Vector)this.profilingStateListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        final ProfilingStateEvent event = new ProfilingStateEvent(oldProfilingState, newProfilingState, this);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    ((ProfilingStateListener)iterator.next()).profilingStateChanged(event);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireThreadsMonitoringChange() {
        Vector toNotify;
        if (this.profilingStateListeners == null) {
            return;
        }
        Profiler profiler = this;
        synchronized (profiler) {
            toNotify = (Vector)this.profilingStateListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    ((ProfilingStateListener)iterator.next()).threadsMonitoringChanged();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireLockContentionMonitoringChange() {
        Vector toNotify;
        if (this.profilingStateListeners == null) {
            return;
        }
        Profiler profiler = this;
        synchronized (profiler) {
            toNotify = (Vector)this.profilingStateListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    ((ProfilingStateListener)iterator.next()).lockContentionMonitoringChanged();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServerStateChanged(final int serverState, final int serverProgress) {
        Vector toNotify;
        if (this.profilingStateListeners == null) {
            return;
        }
        Profiler profiler = this;
        synchronized (profiler) {
            toNotify = (Vector)this.profilingStateListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    ((ProfilingStateListener)iterator.next()).serverStateChanged(serverState, serverProgress);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }
}

