/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Format;

import com.android.tools.smali.baksmali.Adaptors.Format.InstructionMethodItem;
import com.android.tools.smali.baksmali.Adaptors.LabelMethodItem;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.OffsetInstruction;
import java.io.IOException;

public class OffsetInstructionFormatMethodItem
extends InstructionMethodItem<OffsetInstruction> {
    protected LabelMethodItem label;

    public OffsetInstructionFormatMethodItem(BaksmaliOptions options, MethodDefinition methodDef, int codeAddress, OffsetInstruction instruction) {
        super(methodDef, codeAddress, instruction);
        this.label = new LabelMethodItem(options, codeAddress + instruction.getCodeOffset(), this.getLabelPrefix());
        this.label = methodDef.getLabelCache().internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(BaksmaliWriter writer) throws IOException {
        this.label.writeTo(writer);
    }

    private String getLabelPrefix() {
        Opcode opcode = ((OffsetInstruction)this.instruction).getOpcode();
        switch (opcode.format) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }
}

