/*  Example of reading and writing USB Host Shield GPI output
    This example uses "Wiring" style interface. See Blink_LowLevel for example of using low-level UHS interface
    Author: Brian Walton (brian@riban.co.uk)
*/
#include <UHS2_gpio.h>

// Satisfy the IDE, which needs to see the include statment in the ino too.
#ifdef dobogusinclude
#include <spi4teensy3.h>
#endif

#define OUTPUT_PIN 0

USB Usb; // Create an UHS2 interface object
UHS2_GPIO Gpio(&Usb); // Create a GPIO object

void setup() {
  Serial.begin( 115200 );
#if !defined(__MIPSEL__)
  while (!Serial); // Wait for serial port to connect - used on Leonardo, Teensy and other boards with built-in USB CDC serial connection
#endif
  Serial.println("Start");

  if (Usb.Init() == -1)
    Serial.println("OSC did not start.");

  delay( 200 );
}

void loop() {
  // Get the current output value, toggle then wait half a second
  int nValue = Gpio.digitalReadOutput(OUTPUT_PIN);
  nValue = (nValue ? 0 : 1);
  Gpio.digitalWrite(OUTPUT_PIN, nValue);
  Serial.print(nValue ? "+" : "."); // Debug to show what the output should be doing
  delay(500);
}

