/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.oauth.IOAuthAuthorization;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.remotecontrol.handler.AuthorizationHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OAuth20Authorization
implements IOAuthAuthorization {
    private static String getPKCES256CodeChallenge(String cryptographicallyRandomString) {
        try {
            byte[] encodedBytes = cryptographicallyRandomString.getBytes(StandardCharsets.US_ASCII);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return new String(Base64.getUrlEncoder().encode(digest.digest(encodedBytes)), StandardCharsets.US_ASCII).replace("=", "").replace("+", "-").replace("/", "_");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JosmRuntimeException(e);
        }
    }

    @Override
    public void authorize(IOAuthParameters parameters, Consumer<Optional<IOAuthToken>> consumer, Enum<?> ... scopes) {
        String state = UUID.randomUUID().toString();
        String codeVerifier = UUID.randomUUID().toString();
        String s256CodeChallenge = OAuth20Authorization.getPKCES256CodeChallenge(codeVerifier);
        new AuthorizationHandler().getPermissionPreference().put(true);
        String url = parameters.getAuthorizationUrl(state, scopes) + "&code_challenge_method=S256&code_challenge=" + s256CodeChallenge;
        AuthorizationHandler.addAuthorizationConsumer(state, new OAuth20AuthorizationHandler(state, codeVerifier, parameters, consumer));
        GuiHelper.runInEDT(() -> OAuth20Authorization.showUrlOpenFailure(url, OpenBrowser.displayUrl(url)));
    }

    private static void showUrlOpenFailure(String url, String error) {
        if (error != null) {
            HtmlPanel textField = new HtmlPanel("<html><body>" + I18n.tr("The web browser failed to open with the following error: \"{0}\".<br>\nPlease open the following url:<br>\n<a href=\"{1}\">{1}</a><br>\nShould we copy the URL to the clipboard?", error, url) + "</body></html>");
            textField.enableClickableHyperlinks();
            JScrollPane scrollPane = new JScrollPane(textField);
            scrollPane.setPreferredSize(new Dimension(Math.min(textField.getPreferredSize().width + 32, MainApplication.getMainFrame().getWidth() - 240), textField.getPreferredSize().height + scrollPane.getHorizontalScrollBar().getPreferredSize().height * 2));
            GuiHelper.prepareResizeableOptionPane(scrollPane, scrollPane.getPreferredSize());
            int answer = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), scrollPane, I18n.tr("Failed to open browser", new Object[0]), 0, 0);
            if (answer == 0) {
                ClipboardUtils.copyString(url);
            }
        }
    }

    private static class OAuth20AuthorizationHandler
    implements AuthorizationHandler.AuthorizationConsumer {
        private final String state;
        private final IOAuthParameters parameters;
        private final Consumer<Optional<IOAuthToken>> consumer;
        private final String codeVerifier;

        OAuth20AuthorizationHandler(String state, String codeVerifier, IOAuthParameters parameters, Consumer<Optional<IOAuthToken>> consumer) {
            this.state = state;
            this.parameters = parameters;
            this.consumer = consumer;
            this.codeVerifier = codeVerifier;
        }

        @Override
        public void validateRequest(String sender, String request, Map<String, String> args) throws RequestHandler.RequestHandlerBadRequestException {
            String argState = args.get("state");
            if (!Objects.equals(this.state, argState)) {
                throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("Mismatched state: Expected {0} but got {1}", this.state, argState));
            }
        }

        @Override
        public AuthorizationHandler.ResponseRecord handleRequest(String sender, String request, Map<String, String> args) throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
            String code = args.get("code");
            try {
                HttpClient tradeCodeForToken = HttpClient.create(new URL(this.parameters.getAccessTokenUrl()), "POST");
                tradeCodeForToken.setRequestBody(("grant_type=authorization_code&client_id=" + this.parameters.getClientId() + "&redirect_uri=" + this.parameters.getRedirectUri() + "&code=" + code + (String)(this.codeVerifier != null ? "&code_verifier=" + this.codeVerifier : "")).getBytes(StandardCharsets.UTF_8));
                tradeCodeForToken.setHeader("Content-Type", "application/x-www-form-urlencoded");
                try {
                    tradeCodeForToken.connect();
                    HttpClient.Response response = tradeCodeForToken.getResponse();
                    OAuth20Token oAuth20Token = new OAuth20Token(this.parameters, response.getContentReader());
                    this.consumer.accept(Optional.of(oAuth20Token));
                }
                catch (IOException | OAuth20Exception e) {
                    this.consumer.accept(Optional.empty());
                    throw new RequestHandler.RequestHandlerErrorException(e);
                }
                finally {
                    tradeCodeForToken.disconnect();
                }
            }
            catch (MalformedURLException e) {
                this.consumer.accept(Optional.empty());
                throw new RequestHandler.RequestHandlerBadRequestException(e);
            }
            return null;
        }
    }
}

