/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.metamodel.Attribute;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.boot.model.NamedGraphCreator;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.EntityDomainType;

class NamedGraphCreatorJpa
implements NamedGraphCreator {
    private final String name;
    private final NamedEntityGraph annotation;
    private final String jpaEntityName;

    NamedGraphCreatorJpa(NamedEntityGraph annotation, String jpaEntityName) {
        String name = StringHelper.nullIfEmpty(annotation.name());
        this.name = name == null ? jpaEntityName : name;
        this.annotation = annotation;
        this.jpaEntityName = jpaEntityName;
    }

    @Override
    public <T> RootGraphImplementor<T> createEntityGraph(Function<Class<T>, EntityDomainType<?>> entityDomainClassResolver, Function<String, EntityDomainType<?>> entityDomainNameResolver) {
        EntityDomainType<?> rootEntityType = entityDomainNameResolver.apply(this.jpaEntityName);
        RootGraphImplementor<?> entityGraph = NamedGraphCreatorJpa.createRootGraph(this.name, rootEntityType, this.annotation.includeAllAttributes());
        if (this.annotation.subclassSubgraphs() != null) {
            for (NamedSubgraph subclassSubgraph : this.annotation.subclassSubgraphs()) {
                Class subgraphType = subclassSubgraph.type();
                Class graphJavaType = entityGraph.getGraphedType().getJavaType();
                if (!graphJavaType.isAssignableFrom(subgraphType)) {
                    throw new AnnotationException("Named subgraph type '" + subgraphType.getName() + "' is not a subtype of the graph type '" + graphJavaType.getName() + "'");
                }
                Class subtype = subgraphType;
                SubGraphImplementor subgraph = entityGraph.addTreatedSubgraph(subtype);
                this.applyNamedAttributeNodes(subclassSubgraph.attributeNodes(), this.annotation, subgraph);
            }
        }
        if (this.annotation.attributeNodes() != null) {
            this.applyNamedAttributeNodes(this.annotation.attributeNodes(), this.annotation, entityGraph);
        }
        return entityGraph;
    }

    private static <T> RootGraphImplementor<T> createRootGraph(String name, EntityDomainType<T> rootEntityType, boolean includeAllAttributes) {
        RootGraphImpl<T> entityGraph = new RootGraphImpl<T>(name, rootEntityType);
        if (includeAllAttributes) {
            for (Attribute attribute : rootEntityType.getAttributes()) {
                entityGraph.addAttributeNodes(attribute);
            }
        }
        return entityGraph;
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor<?> graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            String keySubgraph;
            AttributeNodeImplementor attributeNode = (AttributeNodeImplementor)graphNode.addAttributeNode(namedAttributeNode.value());
            String subgraph = namedAttributeNode.subgraph();
            if (StringHelper.isNotEmpty(subgraph)) {
                this.applyNamedSubgraphs(namedEntityGraph, subgraph, attributeNode, false);
            }
            if (!StringHelper.isNotEmpty(keySubgraph = namedAttributeNode.keySubgraph())) continue;
            this.applyNamedSubgraphs(namedEntityGraph, keySubgraph, attributeNode, true);
        }
    }

    private <T, E, K> void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, AttributeNodeImplementor<T, E, K> attributeNode, boolean isKeySubGraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, NamedGraphCreatorJpa.createSubgraph(attributeNode, isKeySubGraph, namedSubgraph.type()));
        }
    }

    private static SubGraphImplementor<?> createSubgraph(AttributeNodeImplementor<?, ?, ?> attributeNode, boolean isKeySubGraph, Class<?> subgraphType) {
        if (Void.TYPE.equals(subgraphType)) {
            return attributeNode.addValueSubgraph();
        }
        return isKeySubGraph ? NamedGraphCreatorJpa.makeAttributeNodeKeySubgraph(attributeNode, subgraphType) : NamedGraphCreatorJpa.makeAttributeNodeValueSubgraph(attributeNode, subgraphType);
    }

    private static <T, E, K> SubGraphImplementor<?> makeAttributeNodeValueSubgraph(AttributeNodeImplementor<T, E, K> attributeNode, Class<?> subgraphType) {
        Class<?> attributeValueType = attributeNode.getAttributeDescriptor().getValueGraphType().getJavaType();
        if (!attributeValueType.isAssignableFrom(subgraphType)) {
            throw new AnnotationException("Named subgraph type '" + subgraphType.getName() + "' is not a subtype of the value type '" + attributeValueType.getName() + "'");
        }
        Class<?> castType = subgraphType;
        return attributeNode.addValueSubgraph().addTreatedSubgraph(castType);
    }

    private static <T, E, K> SubGraphImplementor<?> makeAttributeNodeKeySubgraph(AttributeNodeImplementor<T, E, K> attributeNode, Class<?> subgraphType) {
        Class<?> attributeKeyType = attributeNode.getAttributeDescriptor().getKeyGraphType().getJavaType();
        if (!attributeKeyType.isAssignableFrom(subgraphType)) {
            throw new AnnotationException("Named subgraph type '" + subgraphType.getName() + "' is not a subtype of the key type '" + attributeKeyType.getName() + "'");
        }
        Class<?> castType = subgraphType;
        return attributeNode.addKeySubgraph().addTreatedSubgraph(castType);
    }
}

