/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.constantpool;

import io.github.dmlloyd.classfile.BootstrapMethodEntry;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPool;
import io.github.dmlloyd.classfile.constantpool.ConstantValueEntry;
import io.github.dmlloyd.classfile.constantpool.DoubleEntry;
import io.github.dmlloyd.classfile.constantpool.FieldRefEntry;
import io.github.dmlloyd.classfile.constantpool.FloatEntry;
import io.github.dmlloyd.classfile.constantpool.IntegerEntry;
import io.github.dmlloyd.classfile.constantpool.InterfaceMethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.InvokeDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.LoadableConstantEntry;
import io.github.dmlloyd.classfile.constantpool.LongEntry;
import io.github.dmlloyd.classfile.constantpool.MemberRefEntry;
import io.github.dmlloyd.classfile.constantpool.MethodHandleEntry;
import io.github.dmlloyd.classfile.constantpool.MethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.MethodTypeEntry;
import io.github.dmlloyd.classfile.constantpool.ModuleEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.constantpool.PackageEntry;
import io.github.dmlloyd.classfile.constantpool.StringEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.constant.ModuleDesc;
import io.github.dmlloyd.classfile.extras.constant.PackageDesc;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.ClassReaderImpl;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantPoolBuilder
extends ConstantPool {
    public static ConstantPoolBuilder of(ClassModel classModel) {
        return new SplitConstantPool((ClassReaderImpl)classModel.constantPool());
    }

    public static ConstantPoolBuilder of() {
        return new SplitConstantPool();
    }

    public boolean canWriteDirect(ConstantPool var1);

    public Utf8Entry utf8Entry(String var1);

    default public Utf8Entry utf8Entry(ClassDesc desc) {
        return this.utf8Entry(desc.descriptorString());
    }

    default public Utf8Entry utf8Entry(MethodTypeDesc desc) {
        return this.utf8Entry(desc.descriptorString());
    }

    public ClassEntry classEntry(Utf8Entry var1);

    default public ClassEntry classEntry(ClassDesc classDesc) {
        if (Objects.requireNonNull(classDesc).isPrimitive()) {
            throw new IllegalArgumentException("Cannot be encoded as ClassEntry: " + classDesc.displayName());
        }
        AbstractPoolEntry.ClassEntryImpl ret = (AbstractPoolEntry.ClassEntryImpl)this.classEntry(this.utf8Entry(classDesc.isArray() ? classDesc.descriptorString() : Util.toInternalName(classDesc)));
        ret.sym = classDesc;
        return ret;
    }

    public PackageEntry packageEntry(Utf8Entry var1);

    default public PackageEntry packageEntry(PackageDesc packageDesc) {
        return this.packageEntry(this.utf8Entry(packageDesc.internalName()));
    }

    public ModuleEntry moduleEntry(Utf8Entry var1);

    default public ModuleEntry moduleEntry(ModuleDesc moduleDesc) {
        return this.moduleEntry(this.utf8Entry(moduleDesc.name()));
    }

    public NameAndTypeEntry nameAndTypeEntry(Utf8Entry var1, Utf8Entry var2);

    default public NameAndTypeEntry nameAndTypeEntry(String name, ClassDesc type) {
        return this.nameAndTypeEntry(this.utf8Entry(name), this.utf8Entry(type));
    }

    default public NameAndTypeEntry nameAndTypeEntry(String name, MethodTypeDesc type) {
        return this.nameAndTypeEntry(this.utf8Entry(name), this.utf8Entry(type));
    }

    public FieldRefEntry fieldRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public FieldRefEntry fieldRefEntry(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public MethodRefEntry methodRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public MethodRefEntry methodRefEntry(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.methodRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.interfaceMethodRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public MethodTypeEntry methodTypeEntry(MethodTypeDesc var1);

    public MethodTypeEntry methodTypeEntry(Utf8Entry var1);

    default public MethodHandleEntry methodHandleEntry(DirectMethodHandleDesc descriptor) {
        ClassEntry owner = this.classEntry(descriptor.owner());
        NameAndTypeEntry nat = this.nameAndTypeEntry(this.utf8Entry(descriptor.methodName()), this.utf8Entry(descriptor.lookupDescriptor()));
        int n = descriptor.refKind();
        return this.methodHandleEntry(n, switch (descriptor.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.SETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER, DirectMethodHandleDesc.Kind.STATIC_SETTER -> this.fieldRefEntry(owner, nat);
            case DirectMethodHandleDesc.Kind.INTERFACE_STATIC, DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> this.interfaceMethodRefEntry(owner, nat);
            case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.VIRTUAL, DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.CONSTRUCTOR -> this.methodRefEntry(owner, nat);
        });
    }

    public MethodHandleEntry methodHandleEntry(int var1, MemberRefEntry var2);

    default public InvokeDynamicEntry invokeDynamicEntry(DynamicCallSiteDesc dcsd) {
        return this.invokeDynamicEntry(this.bsmEntry((DirectMethodHandleDesc)dcsd.bootstrapMethod(), List.of(dcsd.bootstrapArgs())), this.nameAndTypeEntry(dcsd.invocationName(), dcsd.invocationType()));
    }

    public InvokeDynamicEntry invokeDynamicEntry(BootstrapMethodEntry var1, NameAndTypeEntry var2);

    default public ConstantDynamicEntry constantDynamicEntry(DynamicConstantDesc<?> dcd) {
        return this.constantDynamicEntry(this.bsmEntry(dcd.bootstrapMethod(), List.of(dcd.bootstrapArgs())), this.nameAndTypeEntry(dcd.constantName(), dcd.constantType()));
    }

    public ConstantDynamicEntry constantDynamicEntry(BootstrapMethodEntry var1, NameAndTypeEntry var2);

    public IntegerEntry intEntry(int var1);

    public FloatEntry floatEntry(float var1);

    public LongEntry longEntry(long var1);

    public DoubleEntry doubleEntry(double var1);

    public StringEntry stringEntry(Utf8Entry var1);

    default public StringEntry stringEntry(String value) {
        return this.stringEntry(this.utf8Entry(value));
    }

    default public ConstantValueEntry constantValueEntry(ConstantDesc c) {
        if (c instanceof Integer) {
            Integer i = (Integer)c;
            return this.intEntry(i);
        }
        if (c instanceof String) {
            String s = (String)((Object)c);
            return this.stringEntry(s);
        }
        if (c instanceof Long) {
            Long l = (Long)c;
            return this.longEntry(l);
        }
        if (c instanceof Float) {
            Float f = (Float)c;
            return this.floatEntry(f.floatValue());
        }
        if (c instanceof Double) {
            Double d = (Double)c;
            return this.doubleEntry(d);
        }
        throw new IllegalArgumentException("Illegal type: " + (c == null ? null : c.getClass()));
    }

    default public LoadableConstantEntry loadableConstantEntry(ConstantDesc c) {
        ClassDesc cd;
        if (c instanceof Integer) {
            Integer i = (Integer)c;
            return this.intEntry(i);
        }
        if (c instanceof String) {
            String s = (String)((Object)c);
            return this.stringEntry(s);
        }
        if (c instanceof Long) {
            Long l = (Long)c;
            return this.longEntry(l);
        }
        if (c instanceof Float) {
            Float f = (Float)c;
            return this.floatEntry(f.floatValue());
        }
        if (c instanceof Double) {
            Double d = (Double)c;
            return this.doubleEntry(d);
        }
        if (c instanceof ClassDesc && !(cd = (ClassDesc)c).isPrimitive()) {
            return this.classEntry(cd);
        }
        if (c instanceof MethodTypeDesc) {
            MethodTypeDesc mtd = (MethodTypeDesc)c;
            return this.methodTypeEntry(mtd);
        }
        if (c instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc dmhd = (DirectMethodHandleDesc)c;
            return this.methodHandleEntry(dmhd);
        }
        if (c instanceof DynamicConstantDesc) {
            DynamicConstantDesc dcd = (DynamicConstantDesc)c;
            return this.constantDynamicEntry(dcd);
        }
        throw new IllegalArgumentException("Illegal type: " + (c == null ? null : c.getClass()));
    }

    default public BootstrapMethodEntry bsmEntry(DirectMethodHandleDesc methodReference, List<ConstantDesc> arguments) {
        return this.bsmEntry(this.methodHandleEntry(methodReference), arguments.stream().map(this::loadableConstantEntry).toList());
    }

    public BootstrapMethodEntry bsmEntry(MethodHandleEntry var1, List<LoadableConstantEntry> var2);
}

