/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.types.State;

@NonNullByDefault
public class ItemStateChangedEvent
extends ItemEvent {
    public static final String TYPE = ItemStateChangedEvent.class.getSimpleName();
    protected final State itemState;
    protected final State oldItemState;

    protected ItemStateChangedEvent(String topic, String payload, String itemName, State newItemState, State oldItemState) {
        super(topic, payload, itemName, null);
        this.itemState = newItemState;
        this.oldItemState = oldItemState;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public State getItemState() {
        return this.itemState;
    }

    public State getOldItemState() {
        return this.oldItemState;
    }

    public String toString() {
        return String.format("Item '%s' changed from %s to %s", this.itemName, this.oldItemState, this.itemState);
    }
}

