/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.parser.functions.CalculateEasterSunday;
import de.focus_shift.jollyday.core.parser.functions.CreateHoliday;
import de.focus_shift.jollyday.core.parser.functions.MoveDateRelative;
import de.focus_shift.jollyday.core.parser.predicates.ValidLimitation;
import de.focus_shift.jollyday.core.spi.Described;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.spi.Movable;
import java.time.LocalDate;
import java.time.Year;
import java.util.List;
import java.util.stream.Collectors;

public class ChristianHolidayParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(Year year, Holidays holidays) {
        return holidays.christianHolidays().stream().filter(new ValidLimitation(year)).map(christianHolidayConfiguration -> {
            LocalDate actualDate;
            LocalDate easterSunday = new CalculateEasterSunday(year).apply(christianHolidayConfiguration.chronology());
            switch (christianHolidayConfiguration.type()) {
                case EASTER: {
                    actualDate = easterSunday;
                    break;
                }
                case CLEAN_MONDAY: 
                case SHROVE_MONDAY: {
                    actualDate = easterSunday.minusDays(48L);
                    break;
                }
                case MARDI_GRAS: 
                case CARNIVAL: {
                    actualDate = easterSunday.minusDays(47L);
                    break;
                }
                case ASH_WEDNESDAY: {
                    actualDate = easterSunday.minusDays(46L);
                    break;
                }
                case MAUNDY_THURSDAY: {
                    actualDate = easterSunday.minusDays(3L);
                    break;
                }
                case GOOD_FRIDAY: {
                    actualDate = easterSunday.minusDays(2L);
                    break;
                }
                case EASTER_SATURDAY: {
                    actualDate = easterSunday.minusDays(1L);
                    break;
                }
                case EASTER_MONDAY: {
                    actualDate = easterSunday.plusDays(1L);
                    break;
                }
                case EASTER_TUESDAY: {
                    actualDate = easterSunday.plusDays(2L);
                    break;
                }
                case GENERAL_PRAYER_DAY: {
                    actualDate = easterSunday.plusDays(26L);
                    break;
                }
                case ASCENSION_DAY: {
                    actualDate = easterSunday.plusDays(39L);
                    break;
                }
                case PENTECOST: 
                case WHIT_SUNDAY: {
                    actualDate = easterSunday.plusDays(49L);
                    break;
                }
                case WHIT_MONDAY: 
                case PENTECOST_MONDAY: {
                    actualDate = easterSunday.plusDays(50L);
                    break;
                }
                case CORPUS_CHRISTI: {
                    actualDate = easterSunday.plusDays(60L);
                    break;
                }
                case SACRED_HEART: {
                    actualDate = easterSunday.plusDays(68L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown christian holiday type " + String.valueOf((Object)christianHolidayConfiguration.type()));
                }
            }
            return new MoveDateRelative(actualDate).apply((Movable)christianHolidayConfiguration).map(observedDate -> new CreateHoliday(actualDate, (LocalDate)observedDate)).orElseGet(() -> new CreateHoliday(actualDate)).apply((Described)christianHolidayConfiguration);
        }).collect(Collectors.toList());
    }
}

