/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.Version;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public final class EngineResolver {
    private static Logger logger = LogManager.getLogger(EngineResolver.class);
    public static final EngineResolver INSTANCE = new EngineResolver();

    private EngineResolver() {
    }

    @VisibleForTesting
    KNNEngine resolveEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, String topLevelString, boolean requiresTraining) {
        return this.logAndReturnEngine(this.resolveKNNEngine(knnMethodConfigContext, knnMethodContext, topLevelString, requiresTraining, Version.CURRENT));
    }

    public KNNEngine resolveEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, String topLevelEngineString, boolean requiresTraining, Version version) {
        return this.logAndReturnEngine(this.resolveKNNEngine(knnMethodConfigContext, knnMethodContext, topLevelEngineString, requiresTraining, version));
    }

    private KNNEngine resolveKNNEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, String topLevelEngineString, boolean requiresTraining, Version version) {
        KNNEngine userConfiguredEngine = this.resolveAndValidateUserConfiguredEngine(knnMethodContext, topLevelEngineString, knnMethodConfigContext, requiresTraining);
        if (userConfiguredEngine != KNNEngine.UNDEFINED) {
            return userConfiguredEngine;
        }
        if (requiresTraining) {
            return KNNEngine.FAISS;
        }
        Mode mode = knnMethodConfigContext.getMode();
        CompressionLevel compressionLevel = knnMethodConfigContext.getCompressionLevel();
        if (!Mode.isConfigured(mode) && !CompressionLevel.isConfigured(compressionLevel)) {
            return KNNEngine.DEFAULT;
        }
        if (compressionLevel == CompressionLevel.x4) {
            return KNNEngine.LUCENE;
        }
        if (!CompressionLevel.isConfigured(compressionLevel) || compressionLevel == CompressionLevel.x1) {
            return this.resolveEngineForX1OrNoCompression(mode, version);
        }
        return KNNEngine.FAISS;
    }

    private boolean hasUserConfiguredMethodEngine(KNNMethodContext knnMethodContext) {
        return knnMethodContext != null && knnMethodContext.isEngineConfigured();
    }

    private boolean hasUserConfiguredTopLevelEngine(String topLevelEngineString) {
        KNNEngine topLevelEngine = this.getEngineFromString(topLevelEngineString);
        return topLevelEngine != null && topLevelEngine != KNNEngine.UNDEFINED;
    }

    private KNNEngine resolveAndValidateUserConfiguredEngine(KNNMethodContext knnMethodContext, String topLevelEngineString, KNNMethodConfigContext knnMethodConfigContext, boolean requiresTraining) {
        if (this.hasUserConfiguredMethodEngine(knnMethodContext) && this.hasUserConfiguredTopLevelEngine(topLevelEngineString)) {
            KNNEngine topLevelEngine;
            KNNEngine methodEngine = knnMethodContext.getKnnEngine();
            if (methodEngine == (topLevelEngine = this.validateTopLevelEngine(topLevelEngineString, knnMethodConfigContext, requiresTraining))) {
                return topLevelEngine;
            }
            throw new MapperParsingException(String.format(Locale.ROOT, "Cannot specify conflicting engines: [%s] and [%s]", methodEngine.getName(), topLevelEngine.getName()));
        }
        if (this.hasUserConfiguredMethodEngine(knnMethodContext)) {
            return knnMethodContext.getKnnEngine();
        }
        if (this.hasUserConfiguredTopLevelEngine(topLevelEngineString)) {
            return this.validateTopLevelEngine(topLevelEngineString, knnMethodConfigContext, requiresTraining);
        }
        return KNNEngine.UNDEFINED;
    }

    private KNNEngine resolveEngineForX1OrNoCompression(Mode mode, Version version) {
        if (version != null && version.onOrAfter(Version.V_2_19_0)) {
            return KNNEngine.FAISS;
        }
        return mode == Mode.ON_DISK ? KNNEngine.FAISS : KNNEngine.NMSLIB;
    }

    private KNNEngine logAndReturnEngine(KNNEngine knnEngine) {
        if (KNNEngine.DEPRECATED_ENGINES.contains(knnEngine)) {
            logger.warn("[Deprecation] {} engine is deprecated and will be removed in a future release.", (Object)knnEngine);
        }
        return knnEngine;
    }

    private KNNEngine getEngineFromString(String knnEngineString) {
        if (Strings.isEmpty((CharSequence)knnEngineString)) {
            return KNNEngine.UNDEFINED;
        }
        return KNNEngine.getEngine(knnEngineString);
    }

    private KNNEngine validateTopLevelEngine(String topLevelEngineString, KNNMethodConfigContext knnMethodConfigContext, boolean requiresTraining) {
        KNNEngine topLevelEngine = this.getEngineFromString(topLevelEngineString);
        if (requiresTraining && topLevelEngine != KNNEngine.FAISS) {
            throw new MapperParsingException(String.format(Locale.ROOT, "Cannot specify engine other than FAISS for training", new Object[0]));
        }
        if (knnMethodConfigContext.getCompressionLevel() == CompressionLevel.x4 && topLevelEngine != KNNEngine.LUCENE) {
            throw new MapperParsingException(String.format(Locale.ROOT, "Lucene is the only engine that supports 4x compression", new Object[0]));
        }
        return topLevelEngine;
    }
}

