/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.common;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.securityanalytics.threatIntel.model.CustomSchemaIocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.IocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.JsonPathIocSchema;
import org.opensearch.securityanalytics.threatIntel.model.S3Source;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;
import org.opensearch.securityanalytics.threatIntel.model.UrlDownloadSource;

public class SourceConfigDtoValidator {
    public List<String> validateSourceConfigDto(SATIFSourceConfigDto sourceConfigDto) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        String nameRegex = "^[a-zA-Z0-9 _-]{1,128}$";
        Pattern namePattern = Pattern.compile(nameRegex);
        int MAX_RULE_DESCRIPTION_LENGTH = 65535;
        String descriptionRegex = "^.{0," + MAX_RULE_DESCRIPTION_LENGTH + "}$";
        Pattern descriptionPattern = Pattern.compile(descriptionRegex);
        if (sourceConfigDto.getName() == null || sourceConfigDto.getName().isEmpty()) {
            errorMsgs.add("Name must not be empty");
        } else if (sourceConfigDto.getName() != null && !namePattern.matcher(sourceConfigDto.getName()).matches()) {
            errorMsgs.add("Name must be less than 128 characters and only consist of upper and lowercase letters, numbers 0-9, hyphens, spaces, and underscores");
        }
        if (sourceConfigDto.getFormat() == null || sourceConfigDto.getFormat().isEmpty()) {
            errorMsgs.add("Format must not be empty");
        } else if (sourceConfigDto.getFormat() != null && sourceConfigDto.getFormat().length() > 50) {
            errorMsgs.add("Format must be 50 characters or less");
        }
        if (sourceConfigDto.getDescription() != null && !descriptionPattern.matcher(sourceConfigDto.getDescription()).matches()) {
            errorMsgs.add("Description must be " + MAX_RULE_DESCRIPTION_LENGTH + " characters or less");
        }
        if (sourceConfigDto.getSource() == null) {
            errorMsgs.add("Source must not be empty");
        }
        if (sourceConfigDto.getType() == null) {
            errorMsgs.add("Type must not be empty");
        } else {
            switch (sourceConfigDto.getType()) {
                case IOC_UPLOAD: {
                    if (sourceConfigDto.isEnabled()) {
                        errorMsgs.add("Job Scheduler cannot be enabled for IOC_UPLOAD type");
                    }
                    if (sourceConfigDto.getSchedule() != null) {
                        errorMsgs.add("Cannot pass in schedule for IOC_UPLOAD type");
                    }
                    if (sourceConfigDto.getSource() != null && !(sourceConfigDto.getSource() instanceof IocUploadSource) && !(sourceConfigDto.getSource() instanceof CustomSchemaIocUploadSource)) {
                        errorMsgs.add("Source must be IOC_UPLOAD or custom_schema_ioc_upload type");
                    }
                    if (sourceConfigDto.getSource() instanceof CustomSchemaIocUploadSource) {
                        if (sourceConfigDto.getIocSchema() == null || !(sourceConfigDto.getIocSchema() instanceof JsonPathIocSchema)) {
                            errorMsgs.add("Ioc Schema must be a set of valid json paths for extracting ioc type, ioc value and other fields");
                        }
                        if (Strings.isBlank((String)((CustomSchemaIocUploadSource)sourceConfigDto.getSource()).getIocs())) {
                            errorMsgs.add("Iocs must not be blank for custom_schema_ioc_upload type");
                        }
                    }
                    if (!(sourceConfigDto.getSource() instanceof IocUploadSource) || ((IocUploadSource)sourceConfigDto.getSource()).getIocs() != null || !Strings.isBlank((String)((CustomSchemaIocUploadSource)sourceConfigDto.getSource()).getIocs())) break;
                    errorMsgs.add("Ioc list must include at least one ioc");
                    break;
                }
                case S3_CUSTOM: {
                    if (sourceConfigDto.getSchedule() == null) {
                        errorMsgs.add("Must pass in schedule for S3_CUSTOM type");
                    }
                    if (sourceConfigDto.getSource() == null || sourceConfigDto.getSource() instanceof S3Source) break;
                    errorMsgs.add("Source must be S3_CUSTOM type");
                    break;
                }
                case URL_DOWNLOAD: {
                    if (sourceConfigDto.getSchedule() == null) {
                        errorMsgs.add("Must pass in schedule for URL_DOWNLOAD source type");
                    }
                    if (sourceConfigDto.getSource() == null || sourceConfigDto.getSource() instanceof UrlDownloadSource) break;
                    errorMsgs.add("Source must be URL_DOWNLOAD source type");
                }
            }
        }
        return errorMsgs;
    }
}

