/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.queryset;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.QuerySetEntry;
import org.opensearch.searchrelevance.model.QueryWithReference;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class PutQuerySetTransportAction
extends HandledTransportAction<PutQuerySetRequest, IndexResponse> {
    private final ClusterService clusterService;
    private final QuerySetDao querySetDao;

    @Inject
    public PutQuerySetTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, QuerySetDao querySetDao) {
        super("cluster:admin/opensearch/search_relevance/queryset/put", transportService, actionFilters, PutQuerySetRequest::new);
        this.clusterService = clusterService;
        this.querySetDao = querySetDao;
    }

    protected void doExecute(Task task, PutQuerySetRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        String id = UUID.randomUUID().toString();
        String timestamp = TimeUtils.getTimestamp();
        String name = request.getName();
        String description = request.getDescription();
        String sampling = request.getSampling();
        if (!"manual".equals(sampling)) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Support sampling as manual only. sampling: " + sampling, RestStatus.BAD_REQUEST)));
        }
        List<QueryWithReference> queryWithReferenceList = request.getQuerySetQueries();
        List<QuerySetEntry> querySetQueries = this.convertQuerySetQueriesList(queryWithReferenceList);
        QuerySet querySet = new QuerySet(id, name, description, timestamp, sampling, querySetQueries);
        this.querySetDao.putQuerySet(querySet, listener);
    }

    private List<QuerySetEntry> convertQuerySetQueriesList(List<QueryWithReference> queryWithReferenceList) {
        return queryWithReferenceList.stream().map(queryWithReference -> {
            String queryText = queryWithReference.getReferenceAnswer() != null && !queryWithReference.getReferenceAnswer().isEmpty() ? String.join((CharSequence)"#", queryWithReference.getQueryText(), queryWithReference.getReferenceAnswer()) : queryWithReference.getQueryText();
            return QuerySetEntry.Builder.builder().queryText(queryText).build();
        }).collect(Collectors.toList());
    }
}

