/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.Comparator;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;

public abstract class ValuedAIObject
extends AIObject {
    public static final Comparator<? super ValuedAIObject> ascendingValueComparator = Comparator.comparingInt(ValuedAIObject::getValue);
    public static final Comparator<? super ValuedAIObject> descendingValueComparator = ascendingValueComparator.reversed();
    private int value;

    public ValuedAIObject(AIMain aiMain) {
        super(aiMain);
    }

    public ValuedAIObject(AIMain aiMain, String id) {
        super(aiMain, id);
        this.value = 0;
    }

    public ValuedAIObject(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int newValue) {
        this.value = newValue;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.setValue(xr.getAttribute("value", -1));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ValuedAIObject) {
            ValuedAIObject other = (ValuedAIObject)o;
            return this.value == other.value && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + this.value;
    }
}

