/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.loader;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.cache.JpsCachesLoaderUtil;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.loader.JpsOutputLoader;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.statistics.JpsCacheLoadingSystemStats;
import org.jetbrains.jps.incremental.Utils;

final class JpsCacheLoader
implements JpsOutputLoader<File> {
    private static final Logger LOG = Logger.getInstance(JpsCacheLoader.class);
    private static final String TIMESTAMPS_FOLDER_NAME = "timestamps";
    private static final String FS_STATE_FILE = "fs_state.dat";
    private final File myBuildCacheFolder;
    private final JpsServerClient myClient;
    private final boolean isCleanupAsynchronously;
    private JpsLoaderContext myContext;
    private File myTmpCacheFolder;

    JpsCacheLoader(@NotNull JpsServerClient client, @NotNull String myProjectPath, boolean cleanupAsynchronously) {
        if (client == null) {
            JpsCacheLoader.$$$reportNull$$$0(0);
        }
        if (myProjectPath == null) {
            JpsCacheLoader.$$$reportNull$$$0(1);
        }
        this.myBuildCacheFolder = Utils.getDataStorageRoot(myProjectPath);
        this.myClient = client;
        this.isCleanupAsynchronously = cleanupAsynchronously;
    }

    @Override
    @Nullable
    public File load() {
        LOG.info("Loading JPS caches for commit: " + this.myContext.getCommitId());
        this.myTmpCacheFolder = null;
        long start = System.currentTimeMillis();
        File zipFile = this.myClient.downloadCacheById(this.myContext, this.myContext.getCommitId(), this.myBuildCacheFolder.getParentFile());
        LOG.info("Download of jps caches took: " + (System.currentTimeMillis() - start));
        return zipFile;
    }

    @Override
    public JpsOutputLoader.LoaderStatus extract(@Nullable Object loadResults) {
        if (!(loadResults instanceof File)) {
            return JpsOutputLoader.LoaderStatus.FAILED;
        }
        LOG.info("Start extraction of JPS caches");
        File zipFile = (File)loadResults;
        long fileSize = zipFile.length();
        File tmpFolder = new File(this.myBuildCacheFolder.getParentFile(), "tmp");
        try {
            this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.extracting.downloaded.results", new Object[0]));
            this.myContext.checkCanceled();
            long start = System.currentTimeMillis();
            AtomicInteger extractItemsCount = new AtomicInteger();
            new Decompressor.Zip(zipFile).postProcessor(path -> {
                extractItemsCount.incrementAndGet();
                this.myContext.checkCanceled();
                if (extractItemsCount.get() == 130) {
                    int expectedDownloads = this.myContext.getTotalExpectedDownloads();
                    this.myContext.getNettyClient().sendDescriptionStatusMessage(JpsBuildBundle.message("progress.details.extracting.project.caches", new Object[0]), expectedDownloads);
                    extractItemsCount.set(0);
                }
            }).extract(tmpFolder.toPath());
            JpsCacheLoadingSystemStats.setDecompressionTimeMs(fileSize, System.currentTimeMillis() - start);
            long deletionStart = System.currentTimeMillis();
            FileUtil.delete((File)zipFile);
            JpsCacheLoadingSystemStats.setDeletionTimeMs(fileSize, System.currentTimeMillis() - deletionStart);
            LOG.info("Unzip compilation caches took: " + (System.currentTimeMillis() - start));
            this.myTmpCacheFolder = tmpFolder;
            return JpsOutputLoader.LoaderStatus.COMPLETE;
        }
        catch (ProcessCanceledException | IOException e) {
            if (e instanceof IOException) {
                LOG.warn("Failed unzip downloaded compilation caches", e);
            }
            FileUtil.delete((File)zipFile);
            FileUtil.delete((File)tmpFolder);
            return JpsOutputLoader.LoaderStatus.FAILED;
        }
    }

    @Override
    public void rollback() {
        if (this.myTmpCacheFolder != null && this.myTmpCacheFolder.exists()) {
            FileUtil.delete((File)this.myTmpCacheFolder);
            LOG.debug("JPS cache loader rolled back");
        }
    }

    @Override
    public void apply() {
        if (this.myTmpCacheFolder == null) {
            LOG.warn("Nothing to apply, download results are empty");
            return;
        }
        File newTimestampFolder = new File(this.myTmpCacheFolder, TIMESTAMPS_FOLDER_NAME);
        if (newTimestampFolder.exists()) {
            FileUtil.delete((File)newTimestampFolder);
        }
        this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.applying.jps.caches", new Object[0]));
        if (this.myBuildCacheFolder != null) {
            this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.details.applying.downloaded.caches", new Object[0]));
            File timestamps = new File(this.myBuildCacheFolder, TIMESTAMPS_FOLDER_NAME);
            if (timestamps.exists()) {
                try {
                    newTimestampFolder.mkdirs();
                    FileUtil.copyDir((File)timestamps, (File)newTimestampFolder);
                }
                catch (IOException e) {
                    LOG.warn("Couldn't copy timestamps from old JPS cache", (Throwable)e);
                }
            }
            File fsStateFile = new File(this.myTmpCacheFolder, FS_STATE_FILE);
            fsStateFile.delete();
            try {
                fsStateFile.createNewFile();
            }
            catch (IOException e) {
                LOG.warn("Couldn't create new empty fs_state.dat file", (Throwable)e);
            }
            JpsCachesLoaderUtil.delete(this.myBuildCacheFolder, this.isCleanupAsynchronously);
            this.myTmpCacheFolder.renameTo(this.myBuildCacheFolder);
            LOG.debug("JPS cache downloads finished");
        }
    }

    @Override
    public void setContext(@NotNull JpsLoaderContext context) {
        if (context == null) {
            JpsCacheLoader.$$$reportNull$$$0(2);
        }
        this.myContext = context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProjectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cache/loader/JpsCacheLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

