/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0004J\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0014\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eJ\u0006\u0010\u001f\u001a\u00020\u000eJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00020\"H&\u00a2\u0006\u0002\u0010#R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/SettingsScriptBuilder;", "T", "Lcom/intellij/psi/PsiFile;", "", "scriptFile", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "Lcom/intellij/psi/PsiFile;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "findBlockBody", "", "blockName", "", "startFrom", "getOrPrependTopLevelBlockBody", "getOrAppendInnerBlockBody", "offset", "appendExpressionToBlockIfAbsent", "", "expression", "getOrCreatePluginManagementBody", "addPluginRepositoryExpression", "addMavenCentralPluginRepository", "addPluginRepository", "repository", "Lorg/jetbrains/kotlin/idea/projectConfiguration/RepositoryDescription;", "addIncludedModules", "modules", "", "build", "buildPsiFile", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/psi/PsiFile;", "intellij.kotlin.gradle.codeInsight.common"})
public abstract class SettingsScriptBuilder<T extends PsiFile> {
    @NotNull
    private final T scriptFile;
    @NotNull
    private final StringBuilder builder;

    public SettingsScriptBuilder(@NotNull T scriptFile) {
        Intrinsics.checkNotNullParameter(scriptFile, (String)"scriptFile");
        this.scriptFile = scriptFile;
        this.builder = new StringBuilder(((PsiElement)this.scriptFile).getText());
    }

    private final int findBlockBody(String blockName, int startFrom) {
        int blockOffset = this.builder.indexOf(blockName, startFrom);
        if (blockOffset < 0) {
            return -1;
        }
        return StringsKt.indexOf$default((CharSequence)this.builder, (char)'{', (int)(blockOffset + 1), (boolean)false, (int)4, null) + 1;
    }

    static /* synthetic */ int findBlockBody$default(SettingsScriptBuilder settingsScriptBuilder, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBlockBody");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return settingsScriptBuilder.findBlockBody(string, n);
    }

    private final int getOrPrependTopLevelBlockBody(String blockName) {
        int blockBody = SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
        if (blockBody >= 0) {
            return blockBody;
        }
        this.builder.insert(0, blockName + " {}\n");
        return SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
    }

    private final int getOrAppendInnerBlockBody(String blockName, int offset) {
        int repositoriesBody = this.findBlockBody(blockName, offset);
        if (repositoriesBody >= 0) {
            return repositoriesBody;
        }
        this.builder.insert(offset, "\n" + blockName + " {}\n");
        return this.findBlockBody(blockName, offset);
    }

    private final void appendExpressionToBlockIfAbsent(String expression, int offset) {
        int braceCount = 1;
        int blockEnd = offset;
        int i2 = offset;
        int n = StringsKt.getLastIndex((CharSequence)this.builder);
        if (i2 <= n) {
            while (true) {
                switch (this.builder.charAt(i2)) {
                    case '{': {
                        ++braceCount;
                        break;
                    }
                    case '}': {
                        --braceCount;
                    }
                }
                if (braceCount == 0) {
                    blockEnd = i2;
                    break;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        String string = this.builder.substring(offset, blockEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)((Object)StringsKt.trim((CharSequence)expression)).toString(), (boolean)false, (int)2, null)) {
            this.builder.insert(blockEnd, "\n" + expression + "\n");
        }
    }

    private final int getOrCreatePluginManagementBody() {
        return this.getOrPrependTopLevelBlockBody("pluginManagement");
    }

    protected final void addPluginRepositoryExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        int repositoriesBody = this.getOrAppendInnerBlockBody("repositories", this.getOrCreatePluginManagementBody());
        this.appendExpressionToBlockIfAbsent(expression, repositoriesBody);
    }

    public final void addMavenCentralPluginRepository() {
        this.addPluginRepositoryExpression("mavenCentral()");
    }

    public abstract void addPluginRepository(@NotNull RepositoryDescription var1);

    public final void addIncludedModules(@NotNull List<String> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        this.builder.append(CollectionsKt.joinToString$default((Iterable)modules2, null, (CharSequence)"include ", (CharSequence)"\n", (int)0, null, SettingsScriptBuilder::addIncludedModules$lambda$0, (int)25, null));
    }

    @NotNull
    public final String build() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public abstract T buildPsiFile(@NotNull Project var1);

    private static final CharSequence addIncludedModules$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }
}

