/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.inspections.migration.AbstractDiagnosticBasedMigrationInspection;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationInfoKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/WarningOnMainUnusedParameterMigrationInspection;", "Lorg/jetbrains/kotlin/idea/inspections/migration/AbstractDiagnosticBasedMigrationInspection;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "getDiagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "customIntentionFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "kotlin.idea"})
public final class WarningOnMainUnusedParameterMigrationInspection
extends AbstractDiagnosticBasedMigrationInspection<KtParameter>
implements MigrationFix,
CleanupLocalInspectionTool {
    public WarningOnMainUnusedParameterMigrationInspection() {
        super(KtParameter.class);
    }

    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return MigrationInfoKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_3, LanguageVersion.KOTLIN_1_4);
    }

    @Override
    @NotNull
    public DiagnosticFactoryWithPsiElement<KtParameter, ?> getDiagnosticFactory(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        DiagnosticFactory1 diagnosticFactory1 = Errors.UNUSED_PARAMETER;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory1, (String)"UNUSED_PARAMETER");
        return (DiagnosticFactoryWithPsiElement)diagnosticFactory1;
    }

    @Override
    @NotNull
    public Function1<Diagnostic, IntentionAction> customIntentionFactory() {
        return WarningOnMainUnusedParameterMigrationInspection::customIntentionFactory$lambda$0;
    }

    private static final IntentionAction customIntentionFactory$lambda$0(Diagnostic diagnostic) {
        PsiElement psiElement = diagnostic.getPsiElement();
        KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
        KtNamedFunction ktNamedFunction = ktDeclarationWithBody instanceof KtNamedFunction ? (KtNamedFunction)ktDeclarationWithBody : null;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction ownerFunction = ktNamedFunction;
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)parameter), WarningOnMainUnusedParameterMigrationInspection::customIntentionFactory$lambda$0$lambda$1);
        if (!MainFunctionDetector.isMain$default((MainFunctionDetector)mainFunctionDetector, (KtNamedFunction)ownerFunction, (boolean)false, (boolean)false, (int)6, null)) {
            return null;
        }
        return new RemoveUnusedFunctionParameterFix(parameter, false);
    }

    private static final FunctionDescriptor customIntentionFactory$lambda$0$lambda$1(KtNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)it);
        return declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
    }
}

