/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0014J\u001f\u0010\u001e\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH&\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/builders/IrAbstractBlockBuilder;", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrStatementsBuilder;", "context", "Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "startOffset", "", "endOffset", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "resultType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;Lorg/jetbrains/kotlin/ir/builders/Scope;IILorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "getResultType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setResultType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "statements", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lkotlin/collections/ArrayList;", "addStatement", "", "irStatement", "createBlock", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;)Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "doBuild", "()Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "ir.tree"})
public abstract class IrAbstractBlockBuilder<T extends IrContainerExpression>
extends IrStatementsBuilder<T> {
    @Nullable
    private final IrStatementOrigin origin;
    @Nullable
    private IrType resultType;
    @NotNull
    private final ArrayList<IrStatement> statements;

    public IrAbstractBlockBuilder(@NotNull IrGeneratorContext context2, @NotNull Scope scope2, int startOffset, int endOffset, @Nullable IrStatementOrigin origin, @Nullable IrType resultType) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        super(context2, scope2, startOffset, endOffset);
        this.origin = origin;
        this.resultType = resultType;
        this.statements = new ArrayList();
    }

    @Nullable
    public final IrStatementOrigin getOrigin() {
        return this.origin;
    }

    @Nullable
    public final IrType getResultType() {
        return this.resultType;
    }

    public final void setResultType(@Nullable IrType irType) {
        this.resultType = irType;
    }

    @Override
    protected void addStatement(@NotNull IrStatement irStatement) {
        Intrinsics.checkNotNullParameter(irStatement, "irStatement");
        this.statements.add(irStatement);
    }

    @NotNull
    public abstract T createBlock(@NotNull IrType var1, @Nullable IrStatementOrigin var2);

    @Override
    @NotNull
    public T doBuild() {
        IrType irType = this.resultType;
        if (irType == null) {
            Object t2 = CollectionsKt.lastOrNull((List)this.statements);
            IrExpression irExpression = t2 instanceof IrExpression ? (IrExpression)t2 : null;
            irType = irExpression != null ? irExpression.getType() : null;
            if (irType == null) {
                irType = this.getContext().getIrBuiltIns().getUnitType();
            }
        }
        IrType resultType = irType;
        T irBlock = this.createBlock(resultType, this.origin);
        ((IrStatementContainer)irBlock).getStatements().addAll((Collection<IrStatement>)this.statements);
        return irBlock;
    }
}

