/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.IOException;

public class FileAssert {
    private FileAssert() {
    }

    public static void assertDirectory(File tstvalue, String message) {
        boolean condition = false;
        try {
            condition = tstvalue.isDirectory();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileType(tstvalue), "Directory", message);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileType(tstvalue), "Directory", message);
        }
    }

    public static void assertDirectory(File tstvalue) {
        FileAssert.assertDirectory(tstvalue, null);
    }

    public static void assertFile(File tstvalue, String message) {
        boolean condition = false;
        try {
            condition = tstvalue.isFile();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileType(tstvalue), "File", message);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileType(tstvalue), "File", message);
        }
    }

    public static void assertFile(File tstvalue) {
        FileAssert.assertFile(tstvalue, null);
    }

    public static void assertLength(File tstvalue, long expected, String message) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), String.valueOf(expected), message);
        }
        if (actual != expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), String.valueOf(expected), message);
        }
    }

    public static void assertLength(File tstvalue, long expected) {
        FileAssert.assertLength(tstvalue, expected, null);
    }

    public static void assertMinLength(File tstvalue, long expected, String message) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), "at least " + String.valueOf(expected), message);
        }
        if (actual < expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), "at least " + String.valueOf(expected), message);
        }
    }

    public static void assertMinLength(File tstvalue, long expected) {
        FileAssert.assertMinLength(tstvalue, expected, null);
    }

    public static void assertMaxLength(File tstvalue, long expected, String message) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), "at most " + String.valueOf(expected), message);
        }
        if (actual > expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), "at most " + String.valueOf(expected), message);
        }
    }

    public static void assertMaxLength(File tstvalue, long expected) {
        FileAssert.assertMaxLength(tstvalue, expected, null);
    }

    public static void assertReadable(File tstvalue, String message) {
        boolean condition = false;
        try {
            condition = tstvalue.canRead();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Read Access", message);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Read Access", message);
        }
    }

    public static void assertReadable(File tstvalue) {
        FileAssert.assertReadable(tstvalue, null);
    }

    public static void assertWriteable(File tstvalue, String message) {
        boolean condition = false;
        try {
            condition = tstvalue.canWrite();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Write Access", message);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Write Access", message);
        }
    }

    public static void assertWriteable(File tstvalue) {
        FileAssert.assertReadable(tstvalue, null);
    }

    public static void assertReadWrite(File tstvalue, String message) {
        boolean condition = false;
        try {
            condition = tstvalue.canRead() && tstvalue.canWrite();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Read/Write Access", message);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Read/Write Access", message);
        }
    }

    public static void assertReadWrite(File tstvalue) {
        FileAssert.assertReadWrite(tstvalue, null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        FileAssert.fail(null);
    }

    private static void failFile(File path, String actual, String expected, String message) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        FileAssert.fail((String)formatted + "expected <" + expected + "> but was <" + FileAssert.toString(path) + ">" + (String)(expected != null ? "<" + expected + ">" : ""));
    }

    private static void failSecurity(Exception e, File path, String actual, String expected, String message) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        FileAssert.fail((String)formatted + "expected <" + expected + "> but was <" + FileAssert.toString(path) + "><" + (e != null && e.getMessage() != null && e.getMessage().length() > 0 ? e.getMessage() : "not authorized by JVM") + ">");
    }

    private static String fileType(File path) {
        try {
            if (!path.exists()) {
                return "Nonexistent";
            }
            if (path.isDirectory()) {
                return "Directory";
            }
            if (path.isFile()) {
                return "File";
            }
            return "Special File";
        }
        catch (SecurityException e) {
            return "Unauthorized";
        }
    }

    private static String fileAccess(File path) {
        try {
            if (!path.exists()) {
                return "Nonexistent";
            }
            if (path.canRead() && path.canWrite()) {
                return "Read and Write Access";
            }
            if (path.canRead()) {
                return "Read but not Write Access";
            }
            if (path.canWrite()) {
                return "Write but not Read Access";
            }
            return "Neither Read nor Write Access";
        }
        catch (SecurityException e) {
            return "Unauthorized";
        }
    }

    private static String toString(File path) {
        try {
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            return path.getAbsolutePath();
        }
    }
}

