/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.RecorderBeanInitializedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderConstantDefinitionBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateEntityEnhancer;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaJandexScavenger;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelIndexBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitContributionBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.ProxyBuildingHelper;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.deployment.util.HibernateProcessorUtil;
import io.quarkus.hibernate.orm.dev.HibernateOrmDevIntegrator;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.boot.scan.QuarkusScanner;
import io.quarkus.hibernate.orm.runtime.boot.xml.JAXBElementSubstitution;
import io.quarkus.hibernate.orm.runtime.boot.xml.QNameSubstitution;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.hibernate.orm.runtime.customized.FormatMapperKind;
import io.quarkus.hibernate.orm.runtime.customized.JsonFormatterCustomizationCheck;
import io.quarkus.hibernate.orm.runtime.graal.RegisterServicesForReflectionFeature;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.orm.runtime.schema.SchemaManagementIntegrator;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.hibernate.validator.spi.BeanValidationTraversableResolverBuildItem;
import io.quarkus.panache.hibernate.common.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.panache.hibernate.common.deployment.HibernateModelClassCandidatesForFieldAccessBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.pool.TypePool;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceXmlParser;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class HibernateOrmProcessor {
    public static final String HIBERNATE_ORM_CONFIG_PREFIX = "quarkus.hibernate-orm.";
    private static final Logger LOG = Logger.getLogger(HibernateOrmProcessor.class);
    private static final String INTEGRATOR_SERVICE_FILE = "META-INF/services/org.hibernate.integrator.spi.Integrator";

    @BuildStep
    NativeImageFeatureBuildItem registerServicesForReflection(BuildProducer<ServiceProviderBuildItem> services) {
        for (DotName serviceProvider : ClassNames.SERVICE_PROVIDERS) {
            services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)serviceProvider.toString()));
        }
        return new NativeImageFeatureBuildItem(RegisterServicesForReflectionFeature.class);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerStrategyForReflection(BuildProducer<ReflectiveClassBuildItem> reflective) {
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{LocalTemporaryTableInsertStrategy.class, LocalTemporaryTableMutationStrategy.class}).reason(ClassNames.HIBERNATE_ORM_PROCESSOR.toString()).methods().fields().build());
    }

    @BuildStep
    void registerHibernateOrmMetadataForCoreDialects(BuildProducer<DatabaseKindDialectBuildItem> producer) {
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"db2", (String)"DB2", Set.of("org.hibernate.dialect.DB2Dialect")));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"h2", (String)"H2", Set.of("org.hibernate.dialect.H2Dialect"), (String)"2.3.230"));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"mariadb", (String)"MariaDB", Set.of("org.hibernate.dialect.MariaDBDialect"), (String)"10.6"));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"mssql", (String)"Microsoft SQL Server", Set.of("org.hibernate.dialect.SQLServerDialect"), (String)"13"));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"mysql", (String)"MySQL", Set.of("org.hibernate.dialect.MySQLDialect")));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"oracle", (String)"Oracle", Set.of("org.hibernate.dialect.OracleDialect")));
        producer.produce((BuildItem)DatabaseKindDialectBuildItem.forCoreDialect((String)"postgresql", (String)"PostgreSQL", Set.of("org.hibernate.dialect.PostgreSQLDialect")));
    }

    @BuildStep
    void checkTransactionsSupport(Capabilities capabilities, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        if (capabilities.isMissing("io.quarkus.transactions") && capabilities.isMissing("io.quarkus.hibernate.reactive")) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException("The Hibernate ORM extension is only functional in a JTA environment.")}));
        }
    }

    @BuildStep
    void includeArchivesHostingEntityPackagesInIndex(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalApplicationArchiveMarkers) {
        for (HibernateOrmConfigPersistenceUnit persistenceUnit : hibernateOrmConfig.persistenceUnits().values()) {
            if (!persistenceUnit.packages().isPresent()) continue;
            for (String pakkage : persistenceUnit.packages().get()) {
                additionalApplicationArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(pakkage.replace('.', '/')));
            }
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIf={IsDevelopment.class})
    void warnOfSchemaProblems(HibernateOrmRecorder recorder, HibernateOrmConfig hibernateOrmBuildTimeConfig) {
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> e : hibernateOrmBuildTimeConfig.persistenceUnits().entrySet()) {
            if (!e.getValue().validateInDevMode()) continue;
            recorder.doValidation(e.getKey());
        }
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem addPersistenceUnitAnnotationToIndex() {
        return new AdditionalIndexedClassesBuildItem(ClassNames.QUARKUS_PERSISTENCE_UNIT.toString());
    }

    @BuildStep
    public void enrollBeanValidationTypeSafeActivatorForReflection(Capabilities capabilities, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.boot.beanvalidation.TypeSafeActivator"}).methods().fields().build());
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"jakarta.validation.ConstraintViolation"}).constructors(false).build());
        }
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(HibernateOrmConfig config) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>();
        if (!this.shouldIgnorePersistenceXmlResources(config)) {
            watchedFiles.add(new HotDeploymentWatchedFileBuildItem("META-INF/persistence.xml"));
        }
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem(INTEGRATOR_SERVICE_FILE));
        return watchedFiles;
    }

    @BuildStep
    public void parsePersistenceXmlDescriptors(HibernateOrmConfig config, BuildProducer<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptorBuildItemBuildProducer) {
        if (!this.shouldIgnorePersistenceXmlResources(config)) {
            PersistenceXmlParser parser = PersistenceXmlParser.create(Map.of(), null, (ClassLoaderService)FlatClassLoaderService.INSTANCE);
            List urls = parser.getClassLoaderService().locateResources("META-INF/persistence.xml");
            if (urls.isEmpty()) {
                return;
            }
            for (PersistenceUnitDescriptor desc : parser.parse(urls).values()) {
                persistenceXmlDescriptorBuildItemBuildProducer.produce((BuildItem)new PersistenceXmlDescriptorBuildItem(desc));
            }
        }
    }

    @BuildStep
    public ImpliedBlockingPersistenceUnitTypeBuildItem defineTypeOfImpliedPU(List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.hibernate.reactive") && jdbcDataSourcesBuildItem.isEmpty()) {
            return ImpliedBlockingPersistenceUnitTypeBuildItem.none();
        }
        return ImpliedBlockingPersistenceUnitTypeBuildItem.generateImpliedPersistenceUnit();
    }

    @BuildStep
    public void configurationDescriptorBuilding(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, ImpliedBlockingPersistenceUnitTypeBuildItem impliedPU, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        if (!HibernateProcessorUtil.hasEntities(jpaModel)) {
            LOG.warn((Object)"Hibernate ORM is disabled because no JPA entities were found");
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            PersistenceUnitDescriptor xmlDescriptor = persistenceXmlDescriptorBuildItem.getDescriptor();
            String puName = xmlDescriptor.getName();
            Optional<JdbcDataSourceBuildItem> jdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
            HibernateOrmProcessor.collectDialectConfigForPersistenceXml(puName, xmlDescriptor);
            Optional<FormatMapperKind> jsonMapper = HibernateProcessorUtil.jsonMapperKind(capabilities, hibernateOrmConfig.mapping().format().global());
            Optional<FormatMapperKind> xmlMapper = HibernateProcessorUtil.xmlMapperKind(capabilities, hibernateOrmConfig.mapping().format().global());
            jsonMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
            xmlMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
            JsonFormatterCustomizationCheck jsonFormatterCustomizationCheck = HibernateProcessorUtil.jsonFormatterCustomizationCheck(capabilities, jsonMapper);
            persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(QuarkusPersistenceUnitDescriptor.validateAndReadFrom((PersistenceUnitDescriptor)xmlDescriptor), new RecordedConfig(Optional.of("<default>"), jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind), Optional.empty(), jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion), Optional.ofNullable(xmlDescriptor.getProperties().getProperty("hibernate.dialect")), HibernateOrmProcessor.getMultiTenancyStrategy(Optional.ofNullable(persistenceXmlDescriptorBuildItem.getDescriptor().getProperties().getProperty("hibernate.multiTenancy"))), hibernateOrmConfig.database().ormCompatibilityVersion(), hibernateOrmConfig.mapping().format().global(), jsonFormatterCustomizationCheck, Collections.emptyMap()), null, jpaModel.getXmlMappings(persistenceXmlDescriptorBuildItem.getDescriptor().getName()), true, HibernateProcessorUtil.isHibernateValidatorPresent(capabilities), jsonMapper, xmlMapper));
        }
        if (impliedPU.shouldGenerateImpliedBlockingPersistenceUnit()) {
            this.handleHibernateORMWithNoPersistenceXml(hibernateOrmConfig, index, persistenceXmlDescriptors, jdbcDataSources, applicationArchivesBuildItem, launchMode.getLaunchMode(), jpaModel, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, reflectiveMethods, unremovableBeans, dbKindMetadataBuildItems);
        }
    }

    @BuildStep
    public JpaModelIndexBuildItem jpaEntitiesIndexer(CombinedIndexBuildItem index, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems) {
        HashSet<String> additionalClassNames = new HashSet<String>();
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (AdditionalJpaModelBuildItem additionalJpaModelBuildItem : deprecatedAdditionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        Indexer indexer = new Indexer();
        HashSet hashSet = new HashSet();
        for (String className : additionalClassNames) {
            IndexingUtil.indexClass((String)className, (Indexer)indexer, (IndexView)index.getIndex(), hashSet, (ClassLoader)HibernateOrmProcessor.class.getClassLoader());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getComputingIndex(), indexer.complete()});
        return new JpaModelIndexBuildItem(compositeIndex);
    }

    @BuildStep
    public void contributePersistenceXmlToJpaModel(BuildProducer<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors) {
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptor : persistenceXmlDescriptors) {
            PersistenceUnitDescriptor descriptor = persistenceXmlDescriptor.getDescriptor();
            jpaModelPuContributions.produce((BuildItem)new JpaModelPersistenceUnitContributionBuildItem(descriptor.getName(), descriptor.getPersistenceUnitRootUrl(), descriptor.getManagedClassNames(), descriptor.getMappingFileNames()));
        }
    }

    @BuildStep
    public void contributeQuarkusConfigToJpaModel(BuildProducer<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions, HibernateOrmConfig hibernateOrmConfig) {
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> entry : hibernateOrmConfig.persistenceUnits().entrySet()) {
            String name = entry.getKey();
            HibernateOrmConfigPersistenceUnit config = entry.getValue();
            jpaModelPuContributions.produce((BuildItem)new JpaModelPersistenceUnitContributionBuildItem(name, null, Collections.emptySet(), config.mappingFiles().orElse(Collections.emptySet())));
        }
    }

    @BuildStep
    public void defineJpaEntities(JpaModelIndexBuildItem indexBuildItem, BuildProducer<JpaModelBuildItem> domainObjectsProducer, List<IgnorableNonIndexedClasses> ignorableNonIndexedClassesBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions) throws BuildException {
        Set<String> ignorableNonIndexedClasses = Collections.emptySet();
        if (!ignorableNonIndexedClassesBuildItems.isEmpty()) {
            ignorableNonIndexedClasses = new HashSet();
            for (IgnorableNonIndexedClasses buildItem : ignorableNonIndexedClassesBuildItems) {
                ignorableNonIndexedClasses.addAll(buildItem.getClasses());
            }
        }
        JpaJandexScavenger scavenger = new JpaJandexScavenger(reflectiveClass, hotDeploymentWatchedFiles, jpaModelPuContributions, (IndexView)indexBuildItem.getIndex(), ignorableNonIndexedClasses);
        JpaModelBuildItem domainObjects = scavenger.discoverModelAndRegisterForReflection();
        domainObjectsProducer.produce((BuildItem)domainObjects);
    }

    @BuildStep
    public BytecodeRecorderConstantDefinitionBuildItem pregenProxies(JpaModelBuildItem jpaModel, JpaModelIndexBuildItem indexBuildItem, TransformedClassesBuildItem transformedClassesBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        HashSet<String> managedClassAndPackageNames = new HashSet<String>(jpaModel.getEntityClassNames());
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            managedClassAndPackageNames.addAll(pud.getManagedClassNames());
        }
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            managedClassAndPackageNames.add(additionalJpaModelBuildItem.getClassName());
        }
        PreGeneratedProxies proxyDefinitions = this.generatedProxies(managedClassAndPackageNames, (IndexView)indexBuildItem.getIndex(), transformedClassesBuildItem, generatedClassBuildItemBuildProducer, liveReloadBuildItem);
        return new BytecodeRecorderConstantDefinitionBuildItem(PreGeneratedProxies.class, (Object)proxyDefinitions);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void preGenAnnotationProxies(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions) {
        if (this.hasXmlMappings(persistenceUnitDescriptorBuildItems)) {
            ArrayList<String> annotationClassNames = new ArrayList<String>();
            for (DotName name : ClassNames.JPA_MAPPING_ANNOTATIONS) {
                annotationClassNames.add(name.toString());
            }
            for (DotName name : ClassNames.HIBERNATE_MAPPING_ANNOTATIONS) {
                annotationClassNames.add(name.toString());
            }
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])annotationClassNames.toArray(new String[0])).reason(ClassNames.HIBERNATE_ORM_PROCESSOR.toString()).methods().fields().build());
            for (String annotationClassName : annotationClassNames) {
                proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{annotationClassName}));
            }
        }
    }

    private boolean hasXmlMappings(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems) {
        for (PersistenceUnitDescriptorBuildItem descriptor : persistenceUnitDescriptorBuildItems) {
            if (!descriptor.hasXmlMappings()) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateOrmRecorder recorder, Capabilities capabilities, JpaModelBuildItem jpaModel, HibernateOrmConfig hibernateOrmConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, List<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationBuildItems, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, BuildProducer<BeanValidationTraversableResolverBuildItem> beanValidationTraversableResolver, LaunchModeBuildItem launchMode) throws Exception {
        this.validateHibernatePropertiesNotUsed();
        boolean enableORM = HibernateProcessorUtil.hasEntities(jpaModel);
        boolean hibernateReactivePresent = capabilities.isPresent("io.quarkus.hibernate.reactive");
        if (!hibernateReactivePresent) {
            recorder.callHibernateFeatureInit(enableORM);
        }
        if (!enableORM) {
            return;
        }
        recorder.enlistPersistenceUnit(jpaModel.getEntityClassNames());
        QuarkusScanner scanner = HibernateOrmProcessor.buildQuarkusScanner(jpaModel);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class> integratorClasses = new LinkedHashSet<Class>();
        for (String integratorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)classLoader, (String)INTEGRATOR_SERVICE_FILE)) {
            integratorClasses.add(recorderContext.classProxy(integratorClassName));
        }
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            integratorClasses.add(HibernateOrmDevIntegrator.class);
            integratorClasses.add(SchemaManagementIntegrator.class);
        }
        Map<String, List<HibernateOrmIntegrationStaticDescriptor>> integrationStaticDescriptors = HibernateOrmIntegrationStaticConfiguredBuildItem.collectDescriptors(integrationBuildItems);
        ArrayList<QuarkusPersistenceUnitDefinition> finalStagePUDescriptors = new ArrayList<QuarkusPersistenceUnitDefinition>();
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            finalStagePUDescriptors.add(pud.asOutputPersistenceUnitDefinition(integrationStaticDescriptors.getOrDefault(pud.getPersistenceUnitName(), Collections.emptyList())));
        }
        if (this.hasXmlMappings(persistenceUnitDescriptorBuildItems)) {
            recorderContext.registerSubstitution(JAXBElement.class, JAXBElementSubstitution.Serialized.class, JAXBElementSubstitution.class);
            recorderContext.registerSubstitution(QName.class, QNameSubstitution.Serialized.class, QNameSubstitution.class);
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initMetadata(finalStagePUDescriptors, (Scanner)scanner, integratorClasses)));
        if (capabilities.isPresent("io.quarkus.hibernate.validator") && hibernateOrmConfig.enabled()) {
            beanValidationTraversableResolver.produce((BuildItem)new BeanValidationTraversableResolverBuildItem(recorder.attributeLoadedPredicate()));
        }
    }

    private void validateHibernatePropertiesNotUsed() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("hibernate.properties");
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                throw new IllegalStateException("The Hibernate ORM configuration in Quarkus does not support sourcing configuration properties from resources named `hibernate.properties`, and this is now expressly prohibited as such a file could lead to unpredictable semantics. Please remove it from `" + url.toExternalForm() + "`");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    void handleNativeImageImportSql(BuildProducer<NativeImageResourceBuildItem> resources, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) {
        if (!HibernateProcessorUtil.hasEntities(jpaModel)) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem i : descriptors) {
            String resourceName = i.getExplicitSqlImportScriptResourceName();
            if (resourceName == null) continue;
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{resourceName}));
        }
    }

    @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    @BuildStep
    public HibernateEnhancersRegisteredBuildItem enhancerDomainObjects(JpaModelBuildItem jpaModel, BuildProducer<BytecodeTransformerBuildItem> transformers, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        this.enhanceEntities(jpaModel, transformers, additionalJpaModelBuildItems, deprecatedAdditionalJpaModelBuildItems, additionalClasses);
        return new HibernateEnhancersRegisteredBuildItem();
    }

    @BuildStep
    public HibernateModelClassCandidatesForFieldAccessBuildItem candidatesForFieldAccess(JpaModelBuildItem jpaModel) {
        return new HibernateModelClassCandidatesForFieldAccessBuildItem(jpaModel.getManagedClassNames());
    }

    @BuildStep
    public void build(BuildProducer<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) throws Exception {
        if (!HibernateProcessorUtil.hasEntities(jpaModel)) {
            return;
        }
        HashMap<String, Set<String>> entityPersistenceUnitMapping = new HashMap<String, Set<String>>();
        for (PersistenceUnitDescriptorBuildItem descriptor : descriptors) {
            for (String entityClass : descriptor.getManagedClassNames()) {
                entityPersistenceUnitMapping.putIfAbsent(entityClass, new HashSet());
                ((Set)entityPersistenceUnitMapping.get(entityClass)).add(descriptor.getPersistenceUnitName());
            }
        }
        jpaModelPersistenceUnitMapping.produce((BuildItem)new JpaModelPersistenceUnitMappingBuildItem(entityPersistenceUnitMapping));
    }

    @BuildStep
    @Consume(value=RecorderBeanInitializedBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public PersistenceProviderSetUpBuildItem setupPersistenceProvider(HibernateOrmRecorder recorder, Capabilities capabilities, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            recorder.setupPersistenceProvider(HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        }
        return new PersistenceProviderSetUpBuildItem();
    }

    @BuildStep
    @Consume.List(value={@Consume(value=SyntheticBeansRuntimeInitBuildItem.class), @Consume(value=JdbcDataSourceBuildItem.class), @Consume(value=JdbcDataSourceSchemaReadyBuildItem.class), @Consume(value=PersistenceProviderSetUpBuildItem.class)})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem startPersistenceUnits(HibernateOrmRecorder recorder, BeanContainerBuildItem beanContainer, JpaModelBuildItem jpaModel, ShutdownContextBuildItem shutdownContextBuildItem) {
        if (HibernateProcessorUtil.hasEntities(jpaModel)) {
            recorder.startAllPersistenceUnits(beanContainer.getValue(), (ShutdownContext)shutdownContextBuildItem);
        }
        return new ServiceStartBuildItem("Hibernate ORM");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void multitenancy(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        boolean multitenancyEnabled = false;
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            String persistenceUnitConfigName = persistenceUnitDescriptor.getPersistenceUnitName();
            MultiTenancyStrategy multitenancyStrategy = persistenceUnitDescriptor.getConfig().getMultiTenancyStrategy();
            switch (multitenancyStrategy) {
                case NONE: {
                    break;
                }
                case DISCRIMINATOR: {
                    multitenancyEnabled = true;
                    break;
                }
                case DATABASE: 
                case SCHEMA: {
                    Optional<String> datasource;
                    multitenancyEnabled = true;
                    String multiTenancySchemaDataSource = persistenceUnitDescriptor.getMultiTenancySchemaDataSource();
                    if (multitenancyStrategy == MultiTenancyStrategy.SCHEMA && multiTenancySchemaDataSource != null) {
                        LOG.warnf("Configuration property '%1$s' is deprecated. Use '%2$s' instead.", (Object)HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitConfigName, (String)"multitenant-schema-datasource"), (Object)HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitConfigName, (String)"datasource"));
                        datasource = Optional.of(multiTenancySchemaDataSource);
                    } else {
                        datasource = persistenceUnitDescriptor.getConfig().getDataSource();
                    }
                    SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DataSourceTenantConnectionResolver.class).scope(ApplicationScoped.class)).types(new Class[]{TenantConnectionResolver.class})).setRuntimeInit().defaultBean()).unremovable()).supplier(recorder.dataSourceTenantConnectionResolver(persistenceUnitDescriptor.getPersistenceUnitName(), datasource, persistenceUnitDescriptor.getConfig().getMultiTenancyStrategy()));
                    if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitDescriptor.getPersistenceUnitName())) {
                        configurator.addQualifier(Default.class);
                    } else {
                        configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
                        configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
                    }
                    syntheticBeans.produce((BuildItem)configurator.done());
                }
            }
        }
        if (multitenancyEnabled) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(ClassNames.TENANT_CONNECTION_RESOLVER)));
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(ClassNames.TENANT_RESOLVER)));
        }
    }

    @BuildStep
    public void produceLoggingCategories(HibernateOrmConfig hibernateOrmConfig, BuildProducer<LogCategoryBuildItem> categories) {
        if (hibernateOrmConfig.log().bindParam() || hibernateOrmConfig.log().bindParameters()) {
            categories.produce((BuildItem)new LogCategoryBuildItem("org.hibernate.orm.jdbc.bind", (Level)org.jboss.logmanager.Level.TRACE, true));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerStaticMetamodelClassesForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        Collection annotationInstances = index.getIndex().getAnnotations(ClassNames.STATIC_METAMODEL);
        if (!annotationInstances.isEmpty()) {
            String[] metamodel = (String[])annotationInstances.stream().map(a -> a.target().asClass().name().toString()).toArray(String[]::new);
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])metamodel).reason(ClassNames.HIBERNATE_ORM_PROCESSOR.toString()).constructors(false).fields().build());
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerInjectServiceMethodsForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        HashSet classes = new HashSet();
        ClassNames.ANNOTATED_WITH_INJECT_SERVICE.stream().map(DotName::toString).forEach(classes::add);
        index.getIndex().getAnnotations(ClassNames.INJECT_SERVICE).stream().map(a -> a.target().asMethod().declaringClass().name().toString()).forEach(classes::add);
        if (!classes.isEmpty()) {
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).reason(ClassNames.HIBERNATE_ORM_PROCESSOR.toString()).constructors(false).methods().build());
        }
    }

    private void handleHibernateORMWithNoPersistenceXml(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        if (!descriptors.isEmpty()) {
            if (hibernateOrmConfig.isAnyNonPersistenceXmlPropertySet()) {
                throw new ConfigurationException("A legacy persistence.xml file is present in the classpath, but Hibernate ORM is also configured through the Quarkus config file.\nLegacy persistence.xml files and Quarkus configuration cannot be used at the same time.\nTo ignore persistence.xml files, set the configuration property 'quarkus.hibernate-orm.persistence-xml.ignore' to 'true'.\nTo use persistence.xml files, remove all 'quarkus.hibernate-orm.*' properties from the Quarkus config file.");
            }
            LOG.infof("A legacy persistence.xml file is present in the classpath. This file will be used to configure JPA/Hibernate ORM persistence units, and any configuration of the Hibernate ORM extension will be ignored. To ignore persistence.xml files instead, set the configuration property 'quarkus.hibernate-orm.persistence-xml.ignore' to 'true'.", new Object[0]);
            return;
        }
        if (!hibernateOrmConfig.blocking()) {
            LOG.infof("Hibernate ORM was disabled explicitly by quarkus.hibernate-orm.blocking=false", new Object[0]);
            return;
        }
        Optional<JdbcDataSourceBuildItem> defaultJdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
        boolean enableDefaultPersistenceUnit = defaultJdbcDataSource.isPresent() && hibernateOrmConfig.namedPersistenceUnits().isEmpty() || hibernateOrmConfig.defaultPersistenceUnit().isAnyPropertySet();
        Map<String, Set<String>> modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits(hibernateOrmConfig, jpaModel, index.getIndex(), enableDefaultPersistenceUnit);
        Set<String> modelClassesAndPackagesForDefaultPersistenceUnit = modelClassesAndPackagesPerPersistencesUnits.getOrDefault("<default>", Collections.emptySet());
        HashSet<String> storageEngineCollector = new HashSet<String>();
        if (enableDefaultPersistenceUnit) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, "<default>", hibernateOrmConfig.defaultPersistenceUnit(), modelClassesAndPackagesForDefaultPersistenceUnit, jpaModel.getXmlMappings("<default>"), jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, reflectiveMethods, unremovableBeans, storageEngineCollector, dbKindMetadataBuildItems);
        } else if (!(modelClassesAndPackagesForDefaultPersistenceUnit.isEmpty() || hibernateOrmConfig.defaultPersistenceUnit().datasource().isPresent() && !DataSourceUtil.isDefault((String)hibernateOrmConfig.defaultPersistenceUnit().datasource().get()) || defaultJdbcDataSource.isPresent())) {
            String persistenceUnitName = "<default>";
            String dataSourceName = "<default>";
            throw PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)dataSourceName, (Throwable)DataSourceUtil.dataSourceNotConfigured((String)dataSourceName));
        }
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> persistenceUnitEntry : hibernateOrmConfig.namedPersistenceUnits().entrySet()) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, persistenceUnitEntry.getKey(), persistenceUnitEntry.getValue(), modelClassesAndPackagesPerPersistencesUnits.getOrDefault(persistenceUnitEntry.getKey(), Collections.emptySet()), jpaModel.getXmlMappings(persistenceUnitEntry.getKey()), jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, reflectiveMethods, unremovableBeans, storageEngineCollector, dbKindMetadataBuildItems);
        }
        if (storageEngineCollector.size() > 1) {
            throw new ConfigurationException("The dialect storage engine is a global configuration property: it must be consistent across all persistence units.");
        }
    }

    private static void producePersistenceUnitDescriptorFromConfig(HibernateOrmConfig hibernateOrmConfig, String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, Set<String> modelClassesAndPackages, List<RecordableXmlMapping> xmlMappings, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Set<String> storageEngineCollector, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        Optional<JdbcDataSourceBuildItem> jdbcDataSource = HibernateOrmProcessor.findJdbcDataSource(persistenceUnitName, persistenceUnitConfig, jdbcDataSources);
        if (modelClassesAndPackages.isEmpty()) {
            LOG.warnf("Could not find any entities affected to the persistence unit '%s'.", (Object)persistenceUnitName);
        }
        QuarkusPersistenceUnitDescriptor descriptor = new QuarkusPersistenceUnitDescriptor(persistenceUnitName, PersistenceUnitTransactionType.JTA, new ArrayList<String>(modelClassesAndPackages), new Properties(), false);
        MultiTenancyStrategy multiTenancyStrategy = HibernateOrmProcessor.getMultiTenancyStrategy(persistenceUnitConfig.multitenant());
        Optional<DatabaseKind.SupportedDatabaseKind> supportedDatabaseKind = HibernateOrmProcessor.collectDialectConfig(persistenceUnitName, persistenceUnitConfig, dbKindMetadataBuildItems, jdbcDataSource, multiTenancyStrategy, systemProperties, reflectiveMethods, descriptor.getProperties()::setProperty, storageEngineCollector);
        HibernateProcessorUtil.configureProperties(descriptor, persistenceUnitConfig, hibernateOrmConfig, false);
        HibernateProcessorUtil.configureSqlLoadScript(persistenceUnitName, persistenceUnitConfig, applicationArchivesBuildItem, launchMode, nativeImageResources, hotDeploymentWatchedFiles, descriptor);
        Optional<FormatMapperKind> jsonMapper = HibernateProcessorUtil.jsonMapperKind(capabilities, hibernateOrmConfig.mapping().format().global());
        Optional<FormatMapperKind> xmlMapper = HibernateProcessorUtil.xmlMapperKind(capabilities, hibernateOrmConfig.mapping().format().global());
        jsonMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        xmlMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        JsonFormatterCustomizationCheck jsonFormatterCustomizationCheck = HibernateProcessorUtil.jsonFormatterCustomizationCheck(capabilities, jsonMapper);
        persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(descriptor, new RecordedConfig(jdbcDataSource.map(JdbcDataSourceBuildItem::getName), jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind), supportedDatabaseKind.map(DatabaseKind.SupportedDatabaseKind::getMainName), jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion), persistenceUnitConfig.dialect().dialect(), multiTenancyStrategy, hibernateOrmConfig.database().ormCompatibilityVersion(), hibernateOrmConfig.mapping().format().global(), jsonFormatterCustomizationCheck, persistenceUnitConfig.unsupportedProperties()), persistenceUnitConfig.multitenantSchemaDatasource().orElse(null), xmlMappings, false, HibernateProcessorUtil.isHibernateValidatorPresent(capabilities), jsonMapper, xmlMapper));
    }

    private static Optional<DatabaseKind.SupportedDatabaseKind> collectDialectConfig(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems, Optional<JdbcDataSourceBuildItem> jdbcDataSource, MultiTenancyStrategy multiTenancyStrategy, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BiConsumer<String, String> puPropertiesCollector, Set<String> storageEngineCollector) {
        HibernateOrmConfigPersistenceUnit.HibernateOrmConfigPersistenceUnitDialect dialectConfig = persistenceUnitConfig.dialect();
        Optional<String> dialect = dialectConfig.dialect();
        Optional<String> dbKind = jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind);
        Optional<String> explicitDbMinVersion = jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion);
        if (multiTenancyStrategy != MultiTenancyStrategy.DATABASE && jdbcDataSource.isEmpty()) {
            String dsConfigProperty = HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"datasource");
            throw new ConfigurationException(String.format(Locale.ROOT, "Datasource must be defined for persistence unit '%s'. Setting the datasource for the persistence unit can be done via the '%s' property.  Refer to https://quarkus.io/guides/datasource for guidance.", persistenceUnitName, dsConfigProperty), new HashSet<String>(Arrays.asList("quarkus.datasource.db-kind", "quarkus.datasource.username", "quarkus.datasource.password", "quarkus.datasource.jdbc.url")));
        }
        Optional<DatabaseKind.SupportedDatabaseKind> supportedDatabaseKind = HibernateProcessorUtil.setDialectAndStorageEngine(persistenceUnitName, dbKind, dialect, explicitDbMinVersion, dialectConfig, dbKindMetadataBuildItems, persistenceUnitConfig.dialect().storageEngine(), systemProperties, puPropertiesCollector, storageEngineCollector);
        if (dbKind.isPresent() && DatabaseKind.isPostgreSQL((String)dbKind.get()) || dialect.isPresent() && dialect.get().toLowerCase(Locale.ROOT).contains("postgres")) {
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Accessed in org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver.determineAppropriateResolverDelegate", true, "org.postgresql.jdbc.PgConnection", "getSchema", new String[0]));
        }
        return supportedDatabaseKind;
    }

    private static void collectDialectConfigForPersistenceXml(String persistenceUnitName, PersistenceUnitDescriptor puDescriptor) {
        Properties properties = puDescriptor.getProperties();
        String dialect = puDescriptor.getProperties().getProperty("hibernate.dialect");
        if (!(!"H2".equals(dialect) && !"org.hibernate.dialect.H2Dialect".equals(dialect) || properties.containsKey("jakarta.persistence.database-major-version") || properties.containsKey("jakarta.persistence.database-minor-version") || properties.containsKey("jakarta.persistence.database-product-version"))) {
            Logger.getLogger(HibernateOrmProcessor.class).infof("Persistence unit '%1$s': Enforcing Quarkus defaults for dialect 'org.hibernate.dialect.H2Dialect' by automatically setting '%2$s=%3$s'.", (Object)persistenceUnitName, (Object)"jakarta.persistence.database-product-version", (Object)"2.3.230");
            properties.setProperty("jakarta.persistence.database-product-version", "2.3.230");
        }
    }

    private static Optional<JdbcDataSourceBuildItem> findJdbcDataSource(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, List<JdbcDataSourceBuildItem> jdbcDataSources) {
        if (persistenceUnitConfig.datasource().isPresent()) {
            String dataSourceName = persistenceUnitConfig.datasource().get();
            return Optional.of(jdbcDataSources.stream().filter(i -> dataSourceName.equals(i.getName())).findFirst().orElseThrow(() -> PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)dataSourceName, (Throwable)DataSourceUtil.dataSourceNotConfigured((String)dataSourceName))));
        }
        if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            return jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
        }
        return Optional.empty();
    }

    private void enhanceEntities(JpaModelBuildItem jpaModel, BuildProducer<BytecodeTransformerBuildItem> transformers, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        HibernateEntityEnhancer hibernateEntityEnhancer = new HibernateEntityEnhancer();
        for (String i : jpaModel.getManagedClassNames()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(i).setVisitorFunction((BiFunction)hibernateEntityEnhancer).setCacheable(true).build());
        }
        HashSet<String> additionalClassNames = new HashSet<String>();
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (AdditionalJpaModelBuildItem additionalJpaModelBuildItem : deprecatedAdditionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (String string : additionalClassNames) {
            try {
                byte[] bytes = IoUtil.readClassAsBytes((ClassLoader)HibernateOrmProcessor.class.getClassLoader(), (String)string);
                byte[] enhanced = hibernateEntityEnhancer.enhance(string, bytes);
                additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(false, string, enhanced != null ? enhanced : bytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read Model class", e);
            }
        }
    }

    public static Map<String, Set<String>> getModelClassesAndPackagesPerPersistenceUnits(HibernateOrmConfig hibernateOrmConfig, JpaModelBuildItem jpaModel, IndexView index, boolean enableDefaultPersistenceUnit) {
        HashMap<String, Set<String>> modelClassesAndPackagesPerPersistenceUnits = new HashMap<String, Set<String>>();
        boolean hasPackagesInQuarkusConfig = HibernateOrmProcessor.hasPackagesInQuarkusConfig(hibernateOrmConfig);
        Collection<AnnotationInstance> packageLevelPersistenceUnitAnnotations = HibernateOrmProcessor.getPackageLevelPersistenceUnitAnnotations(index);
        HashMap<String, Set> packageRules = new HashMap<String, Set>();
        if (hasPackagesInQuarkusConfig) {
            if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
                LOG.warn((Object)"Mixing Quarkus configuration and @PersistenceUnit annotations to define the persistence units is not supported. Ignoring the annotations.");
            }
            if (enableDefaultPersistenceUnit) {
                if (!hibernateOrmConfig.defaultPersistenceUnit().packages().isPresent()) {
                    throw new ConfigurationException("Packages must be configured for the default persistence unit.");
                }
                for (String string : hibernateOrmConfig.defaultPersistenceUnit().packages().get()) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add("<default>");
                }
            }
            for (Map.Entry entry : hibernateOrmConfig.namedPersistenceUnits().entrySet()) {
                String candidatePersistenceUnitName = (String)entry.getKey();
                Set<String> candidatePersistenceUnitPackages = ((HibernateOrmConfigPersistenceUnit)entry.getValue()).packages().orElseThrow(() -> new ConfigurationException(String.format(Locale.ROOT, "Packages must be configured for persistence unit '%s'.", candidatePersistenceUnitName)));
                for (String string : candidatePersistenceUnitPackages) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add(candidatePersistenceUnitName);
                }
            }
        } else if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
            for (AnnotationInstance annotationInstance : packageLevelPersistenceUnitAnnotations) {
                String className = annotationInstance.target().asClass().name().toString();
                String packageName = className == null || className.isEmpty() || className.indexOf(46) == -1 ? "" : HibernateOrmProcessor.normalizePackage(className.substring(0, className.lastIndexOf(46)));
                String persistenceUnitName = annotationInstance.value().asString();
                if (persistenceUnitName == null || persistenceUnitName.isEmpty()) continue;
                packageRules.computeIfAbsent(packageName, p -> new HashSet()).add(persistenceUnitName);
            }
        } else {
            if (!hibernateOrmConfig.namedPersistenceUnits().isEmpty()) {
                throw new ConfigurationException("Multiple persistence units are defined but the entities are not mapped to them. You should either use the .packages Quarkus configuration property or package-level @PersistenceUnit annotations.");
            }
            HashSet<String> allModelClassesAndPackages = new HashSet<String>(jpaModel.getAllModelClassNames());
            allModelClassesAndPackages.addAll(jpaModel.getAllModelPackageNames());
            return Collections.singletonMap("<default>", allModelClassesAndPackages);
        }
        TreeSet<String> modelClassesWithPersistenceUnitAnnotations = new TreeSet<String>();
        for (String modelClassName : jpaModel.getAllModelClassNames()) {
            ClassInfo modelClassInfo = index.getClassByName(DotName.createSimple((String)modelClassName));
            Set<String> relatedModelClassNames = HibernateOrmProcessor.getRelatedModelClassNames(index, jpaModel.getAllModelClassNames(), modelClassInfo);
            if (modelClassInfo != null && (modelClassInfo.declaredAnnotation(ClassNames.QUARKUS_PERSISTENCE_UNIT) != null || modelClassInfo.declaredAnnotation(ClassNames.QUARKUS_PERSISTENCE_UNIT_REPEATABLE_CONTAINER) != null)) {
                modelClassesWithPersistenceUnitAnnotations.add(modelClassInfo.name().toString());
            }
            for (Map.Entry entry : packageRules.entrySet()) {
                if (!modelClassName.startsWith((String)entry.getKey())) continue;
                for (String persistenceUnitName : (Set)entry.getValue()) {
                    modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                    ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelClassName);
                    for (String relatedModelClassName : relatedModelClassNames) {
                        ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(relatedModelClassName);
                    }
                }
            }
        }
        if (!modelClassesWithPersistenceUnitAnnotations.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "@PersistenceUnit annotations are not supported at the class level on model classes:\n\t- %s\nUse the `.packages` configuration property or package-level annotations instead.", String.join((CharSequence)"\n\t- ", modelClassesWithPersistenceUnitAnnotations)));
        }
        Set set = modelClassesAndPackagesPerPersistenceUnits.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set unaffectedModelClasses = jpaModel.getAllModelClassNames().stream().filter(c -> !affectedModelClasses.contains(c)).collect(Collectors.toCollection(TreeSet::new));
        if (!unaffectedModelClasses.isEmpty()) {
            LOG.warnf("Could not find a suitable persistence unit for model classes:\n\t- %s", (Object)String.join((CharSequence)"\n\t- ", unaffectedModelClasses));
        }
        for (String modelPackageName : jpaModel.getAllModelPackageNames()) {
            Set set2 = (Set)packageRules.get(HibernateOrmProcessor.normalizePackage(modelPackageName));
            if (set2 == null) continue;
            for (String persistenceUnitName : set2) {
                modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelPackageName);
            }
        }
        return modelClassesAndPackagesPerPersistenceUnits;
    }

    private static Set<String> getRelatedModelClassNames(IndexView index, Set<String> knownModelClassNames, ClassInfo modelClassInfo) {
        if (modelClassInfo == null) {
            return Collections.emptySet();
        }
        HashSet<String> relatedModelClassNames = new HashSet<String>();
        if (modelClassInfo.declaredAnnotation(ClassNames.JPA_ENTITY) == null && modelClassInfo.declaredAnnotation(ClassNames.MAPPED_SUPERCLASS) == null) {
            return Collections.emptySet();
        }
        modelClassInfo = index.getClassByName(modelClassInfo.superName());
        while (modelClassInfo != null && !modelClassInfo.name().equals((Object)DotNames.OBJECT)) {
            String modelSuperClassName = modelClassInfo.name().toString();
            if (knownModelClassNames.contains(modelSuperClassName)) {
                relatedModelClassNames.add(modelSuperClassName);
            }
            modelClassInfo = index.getClassByName(modelClassInfo.superName());
        }
        return relatedModelClassNames;
    }

    private static String normalizePackage(String pakkage) {
        if (pakkage.endsWith(".")) {
            return pakkage;
        }
        return pakkage + ".";
    }

    private static boolean hasPackagesInQuarkusConfig(HibernateOrmConfig hibernateOrmConfig) {
        for (HibernateOrmConfigPersistenceUnit persistenceUnitConfig : hibernateOrmConfig.persistenceUnits().values()) {
            if (!persistenceUnitConfig.packages().isPresent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<AnnotationInstance> getPackageLevelPersistenceUnitAnnotations(IndexView index) {
        Collection persistenceUnitAnnotations = index.getAnnotationsWithRepeatable(ClassNames.QUARKUS_PERSISTENCE_UNIT, index);
        ArrayList<AnnotationInstance> packageLevelPersistenceUnitAnnotations = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance persistenceUnitAnnotation : persistenceUnitAnnotations) {
            if (persistenceUnitAnnotation.target().kind() != AnnotationTarget.Kind.CLASS || !"package-info".equals(persistenceUnitAnnotation.target().asClass().simpleName())) continue;
            packageLevelPersistenceUnitAnnotations.add(persistenceUnitAnnotation);
        }
        return packageLevelPersistenceUnitAnnotations;
    }

    private boolean shouldIgnorePersistenceXmlResources(HibernateOrmConfig config) {
        return config.persistenceXml().ignore() || Boolean.getBoolean("SKIP_PARSE_PERSISTENCE_XML");
    }

    public static QuarkusScanner buildQuarkusScanner(JpaModelBuildItem jpaModel) {
        QuarkusScanner scanner = new QuarkusScanner();
        HashSet<QuarkusScanner.PackageDescriptorImpl> packageDescriptors = new HashSet<QuarkusScanner.PackageDescriptorImpl>();
        for (String packageName : jpaModel.getAllModelPackageNames()) {
            QuarkusScanner.PackageDescriptorImpl desc = new QuarkusScanner.PackageDescriptorImpl(packageName);
            packageDescriptors.add(desc);
        }
        scanner.setPackageDescriptors(packageDescriptors);
        HashSet<QuarkusScanner.ClassDescriptorImpl> classDescriptors = new HashSet<QuarkusScanner.ClassDescriptorImpl>();
        for (String className : jpaModel.getEntityClassNames()) {
            QuarkusScanner.ClassDescriptorImpl desc = new QuarkusScanner.ClassDescriptorImpl(className, ClassDescriptor.Categorization.MODEL);
            classDescriptors.add(desc);
        }
        scanner.setClassDescriptors(classDescriptors);
        return scanner;
    }

    private static MultiTenancyStrategy getMultiTenancyStrategy(Optional<String> multitenancyStrategy) {
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.valueOf((String)multitenancyStrategy.orElse(MultiTenancyStrategy.NONE.name()).toUpperCase(Locale.ROOT));
        return multiTenancyStrategy;
    }

    private PreGeneratedProxies generatedProxies(Set<String> managedClassAndPackageNames, IndexView combinedIndex, TransformedClassesBuildItem transformedClassesBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        ProxyCache proxyCache = (ProxyCache)liveReloadBuildItem.getContextObject(ProxyCache.class);
        if (proxyCache == null) {
            proxyCache = new ProxyCache();
            liveReloadBuildItem.setContextObject(ProxyCache.class, (Object)proxyCache);
        }
        Set changedClasses = Collections.emptySet();
        if (liveReloadBuildItem.getChangeInformation() != null) {
            changedClasses = liveReloadBuildItem.getChangeInformation().getChangedClasses();
        } else {
            proxyCache.cache.clear();
        }
        PreGeneratedProxies preGeneratedProxies = new PreGeneratedProxies();
        TypePool transformedClassesTypePool = this.createTransformedClassesTypePool(transformedClassesBuildItem, managedClassAndPackageNames);
        try (ProxyBuildingHelper proxyHelper = new ProxyBuildingHelper(transformedClassesTypePool);){
            for (String managedClassOrPackageName : managedClassAndPackageNames) {
                CachedProxy result;
                if (proxyCache.cache.containsKey(managedClassOrPackageName) && !this.isModified(managedClassOrPackageName, changedClasses, combinedIndex)) {
                    result = proxyCache.cache.get(managedClassOrPackageName);
                } else {
                    TreeSet<String> proxyInterfaceNames = new TreeSet<String>();
                    proxyInterfaceNames.add(ClassNames.HIBERNATE_PROXY.toString());
                    if (!proxyHelper.isProxiable(managedClassOrPackageName)) continue;
                    String mappedClass = managedClassOrPackageName;
                    DynamicType.Unloaded<?> unloaded = proxyHelper.buildUnloadedProxy(mappedClass, proxyInterfaceNames);
                    result = new CachedProxy(unloaded, proxyInterfaceNames);
                    proxyCache.cache.put(managedClassOrPackageName, result);
                }
                for (Map.Entry i : result.proxyDef.getAllTypes().entrySet()) {
                    generatedClassBuildItemBuildProducer.produce((BuildItem)new GeneratedClassBuildItem(true, ((TypeDescription)i.getKey()).getName(), (byte[])i.getValue()));
                }
                preGeneratedProxies.getProxies().put(managedClassOrPackageName, new PreGeneratedProxies.ProxyClassDetailsHolder(result.proxyDef.getTypeDescription().getName(), result.interfaces));
            }
        }
        return preGeneratedProxies;
    }

    private TypePool createTransformedClassesTypePool(TransformedClassesBuildItem transformedClassesBuildItem, Set<String> entityClasses) {
        HashMap<String, byte[]> transformedClasses = new HashMap<String, byte[]>();
        for (Set transformedClassSet : transformedClassesBuildItem.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass transformedClass : transformedClassSet) {
                String className = transformedClass.getClassName();
                if (!entityClasses.contains(className)) continue;
                transformedClasses.put(className, transformedClass.getData());
            }
        }
        return TypePool.Default.of((ClassFileLocator)new ClassFileLocator.Compound(new ClassFileLocator[]{new ClassFileLocator.Simple(transformedClasses), ClassFileLocator.ForClassLoader.of((ClassLoader)Thread.currentThread().getContextClassLoader())}));
    }

    private boolean isModified(String entity, Set<String> changedClasses, IndexView index) {
        if (changedClasses.contains(entity)) {
            return true;
        }
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)entity));
        if (clazz == null) {
            return false;
        }
        for (DotName i : clazz.interfaceNames()) {
            if (!this.isModified(i.toString(), changedClasses, index)) continue;
            return true;
        }
        DotName superName = clazz.superName();
        if (superName != null) {
            return this.isModified(superName.toString(), changedClasses, index);
        }
        return false;
    }

    private static final class ProxyCache {
        Map<String, CachedProxy> cache = new HashMap<String, CachedProxy>();

        private ProxyCache() {
        }
    }

    static final class CachedProxy {
        final DynamicType.Unloaded<?> proxyDef;
        final Set<String> interfaces;

        CachedProxy(DynamicType.Unloaded<?> proxyDef, Set<String> interfaces) {
            this.proxyDef = proxyDef;
            this.interfaces = interfaces;
        }
    }
}

