/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerDeleteRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportDeleteMemoryContainerAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportDeleteMemoryContainerAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportDeleteMemoryContainerAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ConnectorAccessControlHelper connectorAccessControlHelper, MemoryContainerHelper memoryContainerHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/memory_containers/delete", transportService, actionFilters, MLMemoryContainerDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.memoryContainerHelper = memoryContainerHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLMemoryContainerDeleteRequest deleteRequest = MLMemoryContainerDeleteRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = deleteRequest.getMemoryContainerId();
        String tenantId = deleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to delete this memory container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            this.deleteMemoryContainer(memoryContainerId, tenantId, actionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void deleteMemoryContainer(String memoryContainerId, String tenantId, ActionListener<DeleteResponse> listener) {
        try {
            DeleteDataObjectRequest deleteRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-ml-memory-container")).id(memoryContainerId)).tenantId(tenantId)).build();
            this.sdkClient.deleteDataObjectAsync(deleteRequest).whenComplete((deleteResponse, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)deleteResponse, (Throwable)throwable, deleteRequest.id(), listener));
        }
        catch (Exception e) {
            log.error("Failed to delete Memory Container: {}", (Object)memoryContainerId, (Object)e);
            listener.onFailure(e);
        }
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String memoryContainerId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Memory Container {}", (Object)memoryContainerId, (Object)cause);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find memory container", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            try {
                DeleteResponse deleteResponse = response.deleteResponse();
                log.debug("Completed Delete Memory Container Request, memory container id:{} deleted", (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }
    }
}

