/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.metrics.calculator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Evaluation {
    public static final String METRICS_PRECISION_AT = "Precision@";
    public static final String METRICS_MEAN_AVERAGE_PRECISION_AT = "MAP@";
    public static final String METRICS_NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN_AT = "NDCG@";

    public static double calculatePrecisionAtK(List<String> docIds, Map<String, String> judgmentScores, int k) {
        int relevantCount = 0;
        int count = 0;
        for (String docId : docIds) {
            if (count >= k) break;
            if (judgmentScores.containsKey(docId) && Double.valueOf(judgmentScores.get(docId)) > 0.0) {
                ++relevantCount;
            }
            ++count;
        }
        double precision = k > 0 ? (double)relevantCount / (double)Math.min(k, docIds.size()) : 0.0;
        return (double)Math.round(precision * 100.0) / 100.0;
    }

    private static int countRelevant(Map<String, String> judgmentRatings) {
        int numRel = 0;
        for (String value : judgmentRatings.values()) {
            if (!(Double.valueOf(value) > 0.0)) continue;
            ++numRel;
        }
        return numRel;
    }

    public static double calculateMAPAtK(List<String> docIds, Map<String, String> judgmentScores, int k) {
        double sum = 0.0;
        int relevantCount = 0;
        int numRel = Evaluation.countRelevant(judgmentScores);
        int size = Math.min(k, docIds.size());
        for (int i = 0; i < size; ++i) {
            String docId = docIds.get(i);
            if (!judgmentScores.containsKey(docId) || !(Double.valueOf(judgmentScores.get(docId)) > 0.0)) continue;
            sum += (double)(++relevantCount) / (double)(i + 1);
        }
        double map = relevantCount > 0 ? sum / (double)numRel : 0.0;
        return (double)Math.round(map * 100.0) / 100.0;
    }

    public static double calculateNDCGAtK(List<String> docIds, Map<String, String> judgmentScores, int k) {
        double dcg = 0.0;
        double idcg = Evaluation.calculateIDCG(docIds, judgmentScores, k);
        int size = Math.min(k, docIds.size());
        for (int i = 0; i < size; ++i) {
            String docId = docIds.get(i);
            if (!judgmentScores.containsKey(docId)) continue;
            double relevance = Double.valueOf(judgmentScores.get(docId));
            dcg += (Math.pow(2.0, relevance) - 1.0) / (Math.log(i + 2) / Math.log(2.0));
        }
        double ndcg = idcg > 0.0 ? dcg / idcg : 0.0;
        return (double)Math.round(ndcg * 100.0) / 100.0;
    }

    private static double calculateIDCG(List<String> docIds, Map<String, String> judgmentScores, int k) {
        List relevanceScores = new ArrayList<Double>();
        for (String rel : judgmentScores.values()) {
            relevanceScores.add(Double.valueOf(rel));
        }
        Collections.sort(relevanceScores, Collections.reverseOrder());
        relevanceScores = relevanceScores.subList(0, Math.min(relevanceScores.size(), k));
        double idcg = 0.0;
        for (int i = 0; i < relevanceScores.size(); ++i) {
            idcg += (Math.pow(2.0, (Double)relevanceScores.get(i)) - 1.0) / (Math.log(i + 2) / Math.log(2.0));
        }
        return idcg;
    }
}

