/*
 * Decompiled with CFR 0.152.
 */
package AwsArnParsing_Compile;

import AwsArnParsing_Compile.AmazonDynamodbResource;
import AwsArnParsing_Compile.AmazonDynamodbTableArn;
import AwsArnParsing_Compile.AmazonDynamodbTableName;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsArnIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsRawResourceIdentifier;
import AwsArnParsing_Compile.AwsKmsResource;
import AwsArnParsing_Compile.AwsResource;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName;

public class __default {
    public static boolean ValidAwsKmsResource(AwsResource resource) {
        return resource.Valid() && (resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) || resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"alias")));
    }

    public static boolean ValidAwsKmsArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"kms")) && __default.ValidAwsKmsResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsRawResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _0_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), !((DafnySequence)_0_info.select(0)).equals((Object)DafnySequence.asString((String)"key")), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed raw key id: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsResource._typeDescriptor());
        }
        if ((long)_0_info.cardinalityInt() == 1L) {
            return __default.ParseAwsKmsResources((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"key/"), identifier));
        }
        return __default.ParseAwsKmsResources(identifier);
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _0_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Long.compareUnsigned(_0_info.cardinalityInt(), 1L) > 0, DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _2_resourceType = (DafnySequence)_0_info.select(0);
        DafnySequence _3_value = StandardLibrary_Compile.__default.Join(TypeDescriptor.CHAR, _0_info.drop(1), DafnySequence.asString((String)"/"));
        AwsResource _4_resource = AwsResource.create((DafnySequence<? extends Character>)_2_resourceType, _3_value);
        Outcome<DafnySequence> _5_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsResource(_4_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(AwsResource._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _4_resource);
    }

    public static boolean ValidAmazonDynamodbResource(AwsResource resource) {
        return resource.Valid() && resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"table"));
    }

    public static boolean ValidAmazonDynamodbArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"dynamodb")) && __default.ValidAmazonDynamodbResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAmazonDynamodbResources(DafnySequence<? extends Character> identifier) {
        Option<Tuple2<DafnySequence<Character>, DafnySequence<Character>>> _0_info = StandardLibrary_Compile.__default.SplitOnce_q(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _0_info.is_Some(), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _2_resourceType = (DafnySequence)_0_info.dtor_value().dtor__0();
        DafnySequence _3_value = (DafnySequence)_0_info.dtor_value().dtor__1();
        Outcome<DafnySequence> _4_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName((DafnySequence<? extends Character>)_3_value), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Table Name invalid: "), identifier));
        if (_4_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _4_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        AwsResource _5_resource = AwsResource.create((DafnySequence<? extends Character>)_2_resourceType, (DafnySequence<? extends Character>)_3_value);
        Outcome<DafnySequence> _6_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbResource(_5_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_6_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _6_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(AwsResource._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _5_resource);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAwsKmsArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _0_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), 6L == (long)_0_components.cardinalityInt(), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _2_valueOrError1 = __default.ParseAwsKmsResources((DafnySequence<? extends Character>)((DafnySequence)_0_components.select(5)));
        if (_2_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _2_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _3_resource = _2_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _4_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_0_components.select(0)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(1)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(2)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(3)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(4)), _3_resource);
        Outcome<DafnySequence> _5_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsArn(_4_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_5_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _5_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(AwsArn._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _4_arn);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAmazonDynamodbTableArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _0_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), 6L == (long)_0_components.cardinalityInt(), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _2_valueOrError1 = __default.ParseAmazonDynamodbResources((DafnySequence<? extends Character>)((DafnySequence)_0_components.select(5)));
        if (_2_valueOrError1.IsFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _2_valueOrError1.PropagateFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _3_resource = _2_valueOrError1.Extract(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _4_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_0_components.select(0)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(1)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(2)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(3)), (DafnySequence<? extends Character>)((DafnySequence)_0_components.select(4)), _3_resource);
        Outcome<DafnySequence> _5_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbArn(_4_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_5_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _5_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(AwsArn._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _4_arn);
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> ParseAwsKmsIdentifier(DafnySequence<? extends Character> identifier) {
        if (DafnySequence.asString((String)"arn:").isPrefixOf(identifier)) {
            Result<AwsArn, DafnySequence<? extends Character>> _0_valueOrError0 = __default.ParseAwsKmsArn(identifier);
            if (_0_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _0_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
            }
            AwsArn _1_arn = _0_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success(AwsKmsIdentifier._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier.create_AwsKmsArnIdentifier(_1_arn));
        }
        Result<AwsResource, DafnySequence<? extends Character>> _2_valueOrError1 = __default.ParseAwsKmsRawResources(identifier);
        if (_2_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _2_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        AwsResource _3_r = _2_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return Result.create_Success(AwsKmsIdentifier._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier.create_AwsKmsRawResourceIdentifier(_3_r));
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> ParseAmazonDynamodbTableName(DafnySequence<? extends Character> identifier) {
        Result<AwsArn, DafnySequence<? extends Character>> _0_valueOrError0 = __default.ParseAmazonDynamodbTableArn(identifier);
        if (_0_valueOrError0.IsFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _0_valueOrError0.PropagateFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        AwsArn _1_arn = _0_valueOrError0.Extract(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AmazonDynamodbTableName _2_tableArn = AmazonDynamodbTableName.create(_1_arn);
        DafnySequence<? extends Character> _3_tableName = _2_tableArn.GetTableName();
        return Result.create_Success(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _3_tableName);
    }

    public static boolean IsMultiRegionAwsKmsArn(AwsArn arn) {
        return __default.IsMultiRegionAwsKmsResource(arn.dtor_resource());
    }

    public static boolean IsMultiRegionAwsKmsIdentifier(AwsKmsIdentifier identifier) {
        AwsResource _2___mcc_h1;
        AwsKmsIdentifier _source0 = identifier;
        if (_source0.is_AwsKmsArnIdentifier()) {
            AwsArn _0___mcc_h0;
            AwsArn _1_arn = _0___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source0)._a;
            return __default.IsMultiRegionAwsKmsArn(_1_arn);
        }
        AwsResource _3_r = _2___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source0)._r;
        return __default.IsMultiRegionAwsKmsResource(_3_r);
    }

    public static boolean IsMultiRegionAwsKmsResource(AwsResource resource) {
        return resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) && DafnySequence.asString((String)"mrk-").isPrefixOf(resource.dtor_value());
    }

    public static Option<DafnySequence<? extends Character>> GetRegion(AwsKmsIdentifier identifier) {
        AwsKmsIdentifier _source0 = identifier;
        if (_source0.is_AwsKmsArnIdentifier()) {
            AwsArn _0___mcc_h0;
            AwsArn _1_a = _0___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source0)._a;
            return Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _1_a.dtor_region());
        }
        AwsResource _2___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source0)._r;
        return Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> IsAwsKmsIdentifierString(DafnySequence<? extends Character> s) {
        Outcome<DafnySequence> _0_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), UTF8.__default.IsASCIIString(s), DafnySequence.asString((String)"Not a valid ASCII string."));
        if (_0_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _0_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        Outcome<DafnySequence> _1_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (long)s.cardinalityInt() != 0L && Long.compareUnsigned(s.cardinalityInt(), __default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, DafnySequence.asString((String)"Identifier exceeds maximum length."));
        if (_1_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        return __default.ParseAwsKmsIdentifier(s);
    }

    public static Error Error(DafnySequence<? extends Character> s) {
        return Error.create_AwsCryptographicMaterialProvidersException(s);
    }

    public static Result<Tuple0, Error> ValidateDdbTableArn(DafnySequence<? extends Character> tableArn) {
        Result<DafnySequence<? extends Character>, Error> _0_valueOrError0 = __default.ParseAmazonDynamodbTableName(tableArn).MapFailure(TableName._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::Error);
        if (_0_valueOrError0.IsFailure(TableName._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(TableName._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        DafnySequence<? extends Character> _1___v1 = _0_valueOrError0.Extract(TableName._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(tableArn), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Arn is not ASCII")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _3_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(__default.ParseAmazonDynamodbTableName(tableArn).dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Name is too long")));
        if (_3_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
    }

    public static long MAX__AWS__KMS__IDENTIFIER__LENGTH() {
        return 2048L;
    }

    public String toString() {
        return "AwsArnParsing._default";
    }
}

