/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;

public class DecryptionMaterials {
    private final AlgorithmSuiteInfo algorithmSuite;
    private final Map<String, String> encryptionContext;
    private final List<String> requiredEncryptionContextKeys;
    private final ByteBuffer plaintextDataKey;
    private final ByteBuffer verificationKey;
    private final ByteBuffer symmetricSigningKey;

    protected DecryptionMaterials(BuilderImpl builder) {
        this.algorithmSuite = builder.algorithmSuite();
        this.encryptionContext = builder.encryptionContext();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
        this.plaintextDataKey = builder.plaintextDataKey();
        this.verificationKey = builder.verificationKey();
        this.symmetricSigningKey = builder.symmetricSigningKey();
    }

    public AlgorithmSuiteInfo algorithmSuite() {
        return this.algorithmSuite;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public ByteBuffer plaintextDataKey() {
        return this.plaintextDataKey;
    }

    public ByteBuffer verificationKey() {
        return this.verificationKey;
    }

    public ByteBuffer symmetricSigningKey() {
        return this.symmetricSigningKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteInfo algorithmSuite;
        protected Map<String, String> encryptionContext;
        protected List<String> requiredEncryptionContextKeys;
        protected ByteBuffer plaintextDataKey;
        protected ByteBuffer verificationKey;
        protected ByteBuffer symmetricSigningKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptionMaterials model) {
            this.algorithmSuite = model.algorithmSuite();
            this.encryptionContext = model.encryptionContext();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
            this.plaintextDataKey = model.plaintextDataKey();
            this.verificationKey = model.verificationKey();
            this.symmetricSigningKey = model.symmetricSigningKey();
        }

        @Override
        public Builder algorithmSuite(AlgorithmSuiteInfo algorithmSuite) {
            this.algorithmSuite = algorithmSuite;
            return this;
        }

        @Override
        public AlgorithmSuiteInfo algorithmSuite() {
            return this.algorithmSuite;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public Builder plaintextDataKey(ByteBuffer plaintextDataKey) {
            this.plaintextDataKey = plaintextDataKey;
            return this;
        }

        @Override
        public ByteBuffer plaintextDataKey() {
            return this.plaintextDataKey;
        }

        @Override
        public Builder verificationKey(ByteBuffer verificationKey) {
            this.verificationKey = verificationKey;
            return this;
        }

        @Override
        public ByteBuffer verificationKey() {
            return this.verificationKey;
        }

        @Override
        public Builder symmetricSigningKey(ByteBuffer symmetricSigningKey) {
            this.symmetricSigningKey = symmetricSigningKey;
            return this;
        }

        @Override
        public ByteBuffer symmetricSigningKey() {
            return this.symmetricSigningKey;
        }

        @Override
        public DecryptionMaterials build() {
            if (Objects.isNull(this.algorithmSuite())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuite`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.requiredEncryptionContextKeys())) {
                throw new IllegalArgumentException("Missing value for required field `requiredEncryptionContextKeys`");
            }
            return new DecryptionMaterials(this);
        }
    }

    public static interface Builder {
        public Builder algorithmSuite(AlgorithmSuiteInfo var1);

        public AlgorithmSuiteInfo algorithmSuite();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public Builder plaintextDataKey(ByteBuffer var1);

        public ByteBuffer plaintextDataKey();

        public Builder verificationKey(ByteBuffer var1);

        public ByteBuffer verificationKey();

        public Builder symmetricSigningKey(ByteBuffer var1);

        public ByteBuffer symmetricSigningKey();

        public DecryptionMaterials build();
    }
}

