/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                final SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] byArray) {
                        secureRandom.setSeed(byArray);
                    }

                    @Override
                    protected void engineNextBytes(byte[] byArray) {
                        secureRandom.nextBytes(byArray);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int n) {
                        return secureRandom.generateSeed(n);
                    }
                };
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultEntropySource();
                final FipsSecureRandom fipsSecureRandom = bouncyCastleFipsProvider.getProviderDefaultRandomBuilder().fromEntropySource(secureRandom, true).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(secureRandom.generateSeed(bouncyCastleFipsProvider.getProviderDefaultSecurityStrength() / 16 + 1), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] byArray) {
                        fipsSecureRandom.setSeed(byArray);
                    }

                    @Override
                    protected void engineNextBytes(byte[] byArray) {
                        fipsSecureRandom.nextBytes(byArray);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int n) {
                        return fipsSecureRandom.generateSeed(n);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }
}

