/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.cursor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchModule;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.legacy.cursor.Cursor;
import org.opensearch.sql.legacy.cursor.CursorType;
import org.opensearch.sql.legacy.executor.format.Schema;
import shaded.com.google.common.base.Strings;

public class DefaultCursor
implements Cursor {
    private static final String FETCH_SIZE = "f";
    private static final String ROWS_LEFT = "l";
    private static final String INDEX_PATTERN = "i";
    private static final String SCROLL_ID = "s";
    private static final String SCHEMA_COLUMNS = "c";
    private static final String FIELD_ALIAS_MAP = "a";
    private static final String PIT_ID = "p";
    private static final String SEARCH_REQUEST = "r";
    private static final String SORT_FIELDS = "h";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @NonNull
    private String indexPattern;
    @NonNull
    private List<Schema.Column> columns;
    private final CursorType type = CursorType.DEFAULT;
    private long rowsLeft;
    @NonNull
    private Map<String, String> fieldAliasMap;
    private String scrollId;
    private String pitId;
    private SearchSourceBuilder searchSourceBuilder;
    private Object[] sortFields;
    @NonNull
    private Integer fetchSize;
    private Integer limit;
    private static final NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(new SearchModule(Settings.EMPTY, Collections.emptyList()).getNamedXContents());

    @Override
    public CursorType getType() {
        return this.type;
    }

    @Override
    public String generateCursorId() {
        if (this.rowsLeft <= 0L || this.isCursorIdNullOrEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(FETCH_SIZE, (Object)this.fetchSize);
        json.put(ROWS_LEFT, this.rowsLeft);
        json.put(INDEX_PATTERN, (Object)this.indexPattern);
        json.put(SCHEMA_COLUMNS, (Object)this.getSchemaAsJson());
        json.put(FIELD_ALIAS_MAP, this.fieldAliasMap);
        json.put(PIT_ID, (Object)this.pitId);
        String sortFieldValue = AccessController.doPrivileged(() -> {
            try {
                return objectMapper.writeValueAsString((Object)this.sortFields);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse sort fields from JSON string.", e);
            }
        });
        json.put(SORT_FIELDS, (Object)sortFieldValue);
        this.setSearchRequestString(json, this.searchSourceBuilder);
        return String.format("%s:%s", this.type.getId(), DefaultCursor.encodeCursor(json));
    }

    private void setSearchRequestString(JSONObject cursorJson, SearchSourceBuilder sourceBuilder) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)outputStream);
            sourceBuilder.toXContent(builder, null);
            builder.close();
            String searchRequestBase64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            cursorJson.put("searchSourceBuilder", (Object)searchRequestBase64);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to set search request string on cursor json.", ex);
        }
    }

    private boolean isCursorIdNullOrEmpty() {
        return Strings.isNullOrEmpty((String)this.pitId);
    }

    public static DefaultCursor from(String cursorId) {
        JSONObject json = DefaultCursor.decodeCursor(cursorId);
        DefaultCursor cursor = new DefaultCursor();
        cursor.setFetchSize(json.getInt(FETCH_SIZE));
        cursor.setRowsLeft(json.getLong(ROWS_LEFT));
        cursor.setIndexPattern(json.getString(INDEX_PATTERN));
        DefaultCursor.populateCursorForPit(json, cursor);
        cursor.setColumns(DefaultCursor.getColumnsFromSchema(json.getJSONArray(SCHEMA_COLUMNS)));
        cursor.setFieldAliasMap(DefaultCursor.fieldAliasMap(json.getJSONObject(FIELD_ALIAS_MAP)));
        return cursor;
    }

    private static void populateCursorForPit(JSONObject json, DefaultCursor cursor) {
        cursor.setPitId(json.getString(PIT_ID));
        cursor.setSortFields(DefaultCursor.getSortFieldsFromJson(json));
        String searchSourceBuilderBase64 = json.getString("searchSourceBuilder");
        byte[] bytes = Base64.getDecoder().decode(searchSourceBuilderBase64);
        ByteArrayInputStream streamInput = new ByteArrayInputStream(bytes);
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, DeprecationHandler.IGNORE_DEPRECATIONS, (InputStream)streamInput);
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
            cursor.setSearchSourceBuilder(sourceBuilder);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to get searchSourceBuilder from cursor Id", ex);
        }
    }

    private static Object[] getSortFieldsFromJson(JSONObject json) {
        return AccessController.doPrivileged(() -> {
            try {
                return (Object[])objectMapper.readValue(json.getString(SORT_FIELDS), Object[].class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse sort fields from JSON string.", e);
            }
        });
    }

    private JSONArray getSchemaAsJson() {
        JSONArray schemaJson = new JSONArray();
        for (Schema.Column column : this.columns) {
            schemaJson.put((Object)this.schemaEntry(column.getName(), column.getAlias(), column.getType()));
        }
        return schemaJson;
    }

    private JSONObject schemaEntry(String name, String alias, String type) {
        JSONObject entry = new JSONObject();
        entry.put("name", (Object)name);
        if (alias != null) {
            entry.put("alias", (Object)alias);
        }
        entry.put("type", (Object)type);
        return entry;
    }

    private static String encodeCursor(JSONObject cursorJson) {
        return Base64.getEncoder().encodeToString(cursorJson.toString().getBytes());
    }

    private static JSONObject decodeCursor(String cursorId) {
        return new JSONObject(new String(Base64.getDecoder().decode(cursorId)));
    }

    private static Map<String, String> fieldAliasMap(JSONObject json) {
        HashMap<String, String> fieldToAliasMap = new HashMap<String, String>();
        json.keySet().forEach(key -> fieldToAliasMap.put((String)key, json.get(key).toString()));
        return fieldToAliasMap;
    }

    private static List<Schema.Column> getColumnsFromSchema(JSONArray schema) {
        List<Schema.Column> columns = IntStream.range(0, schema.length()).mapToObj(i -> {
            JSONObject jsonColumn = schema.getJSONObject(i);
            return new Schema.Column(jsonColumn.getString("name"), jsonColumn.optString("alias", null), Schema.Type.valueOf(jsonColumn.getString("type").toUpperCase()));
        }).collect(Collectors.toList());
        return columns;
    }

    @NonNull
    @Generated
    public String getIndexPattern() {
        return this.indexPattern;
    }

    @NonNull
    @Generated
    public List<Schema.Column> getColumns() {
        return this.columns;
    }

    @Generated
    public long getRowsLeft() {
        return this.rowsLeft;
    }

    @NonNull
    @Generated
    public Map<String, String> getFieldAliasMap() {
        return this.fieldAliasMap;
    }

    @Generated
    public String getScrollId() {
        return this.scrollId;
    }

    @Generated
    public String getPitId() {
        return this.pitId;
    }

    @Generated
    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    @Generated
    public Object[] getSortFields() {
        return this.sortFields;
    }

    @NonNull
    @Generated
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public void setIndexPattern(@NonNull String indexPattern) {
        if (indexPattern == null) {
            throw new NullPointerException("indexPattern is marked non-null but is null");
        }
        this.indexPattern = indexPattern;
    }

    @Generated
    public void setColumns(@NonNull List<Schema.Column> columns) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.columns = columns;
    }

    @Generated
    public void setRowsLeft(long rowsLeft) {
        this.rowsLeft = rowsLeft;
    }

    @Generated
    public void setFieldAliasMap(@NonNull Map<String, String> fieldAliasMap) {
        if (fieldAliasMap == null) {
            throw new NullPointerException("fieldAliasMap is marked non-null but is null");
        }
        this.fieldAliasMap = fieldAliasMap;
    }

    @Generated
    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    @Generated
    public void setPitId(String pitId) {
        this.pitId = pitId;
    }

    @Generated
    public void setSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
        this.searchSourceBuilder = searchSourceBuilder;
    }

    @Generated
    public void setSortFields(Object[] sortFields) {
        this.sortFields = sortFields;
    }

    @Generated
    public void setFetchSize(@NonNull Integer fetchSize) {
        if (fetchSize == null) {
            throw new NullPointerException("fetchSize is marked non-null but is null");
        }
        this.fetchSize = fetchSize;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public DefaultCursor() {
    }
}

