"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OuiDataGridCellPopover = OuiDataGridCellPopover;
Object.defineProperty(exports, "EuiDataGridCellPopover", {
  enumerable: true,
  get: function get() {
    return _data_grid_cell_popover.EuiDataGridCellPopover;
  }
});
var _react = _interopRequireDefault(require("react"));
var _popover = require("../popover");
var _services = require("../../services");
var _flex = require("../flex");
var _button_empty = require("../button/button_empty");
var _data_grid_cell_popover = require("../../eui_components/datagrid/data_grid_cell_popover");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function OuiDataGridCellPopover(_ref) {
  var anchorContent = _ref.anchorContent,
    cellContentProps = _ref.cellContentProps,
    cellContentsRef = _ref.cellContentsRef,
    closePopover = _ref.closePopover,
    column = _ref.column,
    panelRefFn = _ref.panelRefFn,
    PopoverContent = _ref.popoverContent,
    popoverIsOpen = _ref.popoverIsOpen,
    renderCellValue = _ref.renderCellValue,
    rowIndex = _ref.rowIndex;
  var CellElement = renderCellValue;
  return /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, {
    hasArrow: false,
    anchorClassName: "ouiDataGridRowCell__expand",
    button: anchorContent,
    isOpen: popoverIsOpen,
    panelRef: panelRefFn,
    panelClassName: "ouiDataGridRowCell__popover",
    panelPaddingSize: "s",
    zIndex: 8001,
    display: "block",
    closePopover: closePopover,
    onKeyDown: function onKeyDown(event) {
      if (event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        closePopover();
      }
    }
  }, popoverIsOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PopoverContent, {
    cellContentsElement: cellContentsRef
  }, /*#__PURE__*/_react.default.createElement(CellElement, _extends({}, cellContentProps, {
    isDetails: true
  }))), column && column.cellActions && column.cellActions.length ? /*#__PURE__*/_react.default.createElement(_popover.OuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
    gutterSize: "s"
  }, column.cellActions.map(function (Action, idx) {
    var CellButtonElement = Action;
    return /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
      key: idx
    }, /*#__PURE__*/_react.default.createElement(CellButtonElement, {
      rowIndex: rowIndex,
      columnId: column.id,
      Component: function Component(props) {
        return /*#__PURE__*/_react.default.createElement(_button_empty.OuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true,
      closePopover: closePopover
    }));
  }))) : null) : null);
}

/* OUI -> EUI Aliases: Build-Time */