/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.jcraft.jsch.agentproxy.USocketFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ssh/Msys2EmulatedUnixSocketFactory;", "Lcom/jcraft/jsch/agentproxy/USocketFactory;", "currentPid", "", "uid", "gid", "userTempDirectory", "Ljava/io/File;", "<init>", "(IIILjava/io/File;)V", "open", "Lcom/jcraft/jsch/agentproxy/USocketFactory$Socket;", "path", "", "Companion", "CygwinEmulatedUnixSocket", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nMsys2EmulatedUnixSocketFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Msys2EmulatedUnixSocketFactory.kt\ncom/intellij/ssh/Msys2EmulatedUnixSocketFactory\n+ 2 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n284#2,5:140\n1#3:145\n13493#4,2:146\n*S KotlinDebug\n*F\n+ 1 Msys2EmulatedUnixSocketFactory.kt\ncom/intellij/ssh/Msys2EmulatedUnixSocketFactory\n*L\n96#1:140,5\n96#1:145\n107#1:146,2\n*E\n"})
public final class Msys2EmulatedUnixSocketFactory
implements USocketFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int currentPid;
    private final int uid;
    private final int gid;
    @NotNull
    private final File userTempDirectory;
    @NotNull
    private static final Regex socketFileRegex = new Regex("^!<socket >(\\d+) s ([\\da-fA-F-]{1,36})\\u0000$");

    public Msys2EmulatedUnixSocketFactory(int currentPid, int uid, int gid, @NotNull File userTempDirectory) {
        Intrinsics.checkNotNullParameter((Object)userTempDirectory, (String)"userTempDirectory");
        this.currentPid = currentPid;
        this.uid = uid;
        this.gid = gid;
        this.userTempDirectory = userTempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public USocketFactory.Socket open(@NotNull String path) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"/tmp", (boolean)false, (int)2, null)) {
            String string2 = this.userTempDirectory.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            string = StringsKt.replaceFirst$default((String)path, (String)"/tmp", (String)string2, (boolean)false, (int)4, null);
        } else {
            string = path;
        }
        String windowsSocketPath = string;
        File socketFile = new File(windowsSocketPath);
        if (!socketFile.isFile()) {
            throw new FileNotFoundException("Unix socket file '" + socketFile.getAbsolutePath() + "' does not exist");
        }
        File $this$useLines_u24default$iv = socketFile;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object2 = $this$useLines_u24default$iv;
        int n = 8192;
        Object object3 = object2;
        object2 = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), charset$iv)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        Throwable throwable = null;
        try {
            Object it$iv = (BufferedReader)object2;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            it$iv = (String)SequencesKt.firstOrNull((Sequence)it);
            object = it$iv;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        if (object == null) {
            throw new IOException("Socket file " + socketFile + " is empty");
        }
        Object firstLine = object;
        Pair<Integer, int[]> pair = Companion.parsePortAndGuid((String)firstLine);
        int port = ((Number)pair.component1()).intValue();
        int[] fileGuid = (int[])pair.component2();
        Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
        InputStream socketInputStream = socket.getInputStream();
        OutputStream socketOutputStream = socket.getOutputStream();
        LittleEndianDataInputStream dataInputStream = new LittleEndianDataInputStream(socketInputStream);
        LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(socketOutputStream);
        int[] $this$forEach$iv = fileGuid;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            dataOutputStream.writeInt(it);
        }
        int n3 = 0;
        int[] nArray = new int[4];
        while (n3 < 4) {
            n2 = n3++;
            nArray[n2] = dataInputStream.readInt();
        }
        int[] remoteGuid = nArray;
        if (!Arrays.equals(remoteGuid, fileGuid)) {
            throw new IOException("Cygwin Unix Socket handshake failed: GUIDs '" + ArraysKt.joinToString$default((int[])remoteGuid, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' and '" + ArraysKt.joinToString$default((int[])fileGuid, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' are not equal");
        }
        dataOutputStream.writeInt(this.currentPid);
        dataOutputStream.writeInt(this.uid);
        dataOutputStream.writeInt(this.gid);
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        return new CygwinEmulatedUnixSocket(socket);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ssh/Msys2EmulatedUnixSocketFactory$Companion;", "", "<init>", "()V", "socketFileRegex", "Lkotlin/text/Regex;", "parsePortAndGuid", "Lkotlin/Pair;", "", "", "socketFileContent", "", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Integer, int[]> parsePortAndGuid(@NotNull String socketFileContent) {
            Pair pair;
            block9: {
                block8: {
                    Pair pair2;
                    block7: {
                        Pair pair3;
                        List list;
                        Intrinsics.checkNotNullParameter((Object)socketFileContent, (String)"socketFileContent");
                        MatchResult matchResult = socketFileRegex.matchEntire((CharSequence)socketFileContent);
                        if (matchResult == null || (list = matchResult.getGroupValues()) == null) break block8;
                        List list2 = list;
                        boolean bl = false;
                        String portStr = (String)list2.get(1);
                        String uuidStr = (String)list2.get(2);
                        try {
                            char[] cArray = new char[]{'-'};
                            List uuidParts = StringsKt.split$default((CharSequence)uuidStr, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                            if (((Collection)uuidParts).size() != 4) {
                                pair2 = null;
                                break block7;
                            }
                            int n = 0;
                            int[] nArray = new int[4];
                            Integer n2 = Integer.parseInt(portStr);
                            while (n < 4) {
                                int n3 = n++;
                                nArray[n3] = (int)Long.parseLong((String)uuidParts.get(n3), CharsKt.checkRadix((int)16));
                            }
                            pair3 = TuplesKt.to((Object)n2, (Object)nArray);
                        }
                        catch (Exception exception) {
                            pair2 = null;
                            break block7;
                        }
                        pair2 = pair3;
                    }
                    pair = pair2;
                    if (pair != null) break block9;
                }
                throw new IOException("Invalid socket file content: " + socketFileContent);
            }
            Pair pair4 = pair;
            int port = ((Number)pair4.component1()).intValue();
            int[] uuid = (int[])pair4.component2();
            return new Pair((Object)port, (Object)uuid);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ssh/Msys2EmulatedUnixSocketFactory$CygwinEmulatedUnixSocket;", "Lcom/jcraft/jsch/agentproxy/USocketFactory$Socket;", "socket", "Ljava/net/Socket;", "<init>", "(Ljava/net/Socket;)V", "readFull", "", "buf", "", "s", "len", "write", "", "close", "intellij.platform.ssh"})
    public static final class CygwinEmulatedUnixSocket
    extends USocketFactory.Socket {
        @NotNull
        private final Socket socket;

        public CygwinEmulatedUnixSocket(@NotNull Socket socket) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.socket = socket;
        }

        public int readFull(@NotNull byte[] buf, int s, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return this.socket.getInputStream().read(buf, s, len);
        }

        public void write(@NotNull byte[] buf, int s, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.socket.getOutputStream().write(buf, s, len);
        }

        public void close() {
            this.socket.close();
        }
    }
}

