/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.testFramework.common.FileSystemProviderInjector;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u001a1\u0010\u0005\u001a\u00020\u00012'\u0010\u0006\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u00a8\u0006\r"}, d2={"injectFileSystemProviders", "", "executeUnderLock", "runnable", "Lkotlin/Function0;", "modifyProviders", "mutator", "Lkotlin/Function1;", "", "Ljava/nio/file/spi/FileSystemProvider;", "Lkotlin/ParameterName;", "name", "providers", "intellij.platform.testFramework.common"})
@SourceDebugExtension(value={"SMAP\nFileSystemProviderInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemProviderInjector.kt\ncom/intellij/testFramework/common/FileSystemProviderInjectorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n1208#2,2:74\n1236#2,4:76\n2746#2,3:83\n536#3:80\n521#3,2:81\n523#3,4:86\n13#4:90\n*S KotlinDebug\n*F\n+ 1 FileSystemProviderInjector.kt\ncom/intellij/testFramework/common/FileSystemProviderInjectorKt\n*L\n22#1:74,2\n22#1:76,4\n26#1:83,3\n25#1:80\n25#1:81,2\n25#1:86,4\n39#1:90\n*E\n"})
public final class FileSystemProviderInjectorKt {
    /*
     * WARNING - void declaration
     */
    public static final void injectFileSystemProviders() {
        void $this$filterTo$iv$iv;
        Map desiredProvidersByScheme;
        Object object;
        Object element$iv$iv;
        Map $this$associateByTo$iv$iv;
        ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$associateBy$iv = serviceLoader;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            element$iv$iv = iterator.next();
            object = (FileSystemProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getScheme(), element$iv$iv);
        }
        Map $this$filter$iv = desiredProvidersByScheme = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            block8: {
                object = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl2 = false;
                String scheme = (String)object.getKey();
                List<FileSystemProvider> list = FileSystemProvider.installedProviders();
                Intrinsics.checkNotNullExpressionValue(list, (String)"installedProviders(...)");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FileSystemProvider it = (FileSystemProvider)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getScheme(), (Object)scheme)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection providersToAdd = destination$iv$iv.values();
        if (!providersToAdd.isEmpty()) {
            try {
                FileSystemProviderInjectorKt.executeUnderLock((Function0<Unit>)((Function0)() -> FileSystemProviderInjectorKt.injectFileSystemProviders$lambda$2(providersToAdd)));
            }
            catch (InaccessibleObjectException err) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(FileSystemProviderInjector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("The test process runs with an invalid classloader and attempt to autofix it failed. It can lead to errors in tests that use IJent NIO file system. To make the test work, add `--add-opens java.base/java.nio.file.spi=ALL-UNNAMED` to VM options of the test process.", (Throwable)err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void executeUnderLock(Function0<Unit> runnable) {
        Field lockField = FileSystemProvider.class.getDeclaredField("lock");
        lockField.setAccessible(true);
        Object object = lockField.get(FileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            runnable.invoke();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void modifyProviders(Function1<? super List<FileSystemProvider>, Unit> mutator) {
        FileSystemProvider.installedProviders();
        Class<FileSystemProvider> klass = FileSystemProvider.class;
        Field installedProvidersField = klass.getDeclaredField("installedProviders");
        installedProvidersField.setAccessible(true);
        Object object = installedProvidersField.get(klass);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.nio.file.spi.FileSystemProvider>");
        List providers = (List)object;
        List newProviders = new ArrayList();
        newProviders.addAll(providers);
        mutator.invoke((Object)newProviders);
        installedProvidersField.set(klass, newProviders);
    }

    private static final Unit injectFileSystemProviders$lambda$2(Collection $providersToAdd) {
        FileSystemProviderInjectorKt.modifyProviders((Function1<? super List<FileSystemProvider>, Unit>)((Function1)arg_0 -> FileSystemProviderInjectorKt.injectFileSystemProviders$lambda$2$0($providersToAdd, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit injectFileSystemProviders$lambda$2$0(Collection $providersToAdd, List providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        providers.addAll($providersToAdd);
        return Unit.INSTANCE;
    }
}

