/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.toolbox.Substring;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocStringUtil {
    private DocStringUtil() {
    }

    @Deprecated
    @Nullable
    public static String getDocStringValue(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(0);
        }
        return DocStringUtilCore.getDocStringValue((PyAstDocStringOwner)owner);
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(1);
        }
        return DocStringUtil.parse(text, null);
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text, @Nullable PsiElement anchor) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(2);
        }
        DocStringFormat format = DocStringParser.guessDocStringFormat((String)text, (PsiElement)anchor);
        return DocStringUtil.parseDocStringContent(format, text);
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull PyStringLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(3);
        }
        return DocStringUtil.parseDocString(DocStringParser.guessDocStringFormat((String)stringLiteral.getStringValue(), (PsiElement)stringLiteral), stringLiteral);
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull PyStringLiteralExpression stringLiteral) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(4);
        }
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(5);
        }
        return DocStringUtil.parseDocString(format, (ASTNode)stringLiteral.getStringNodes().get(0));
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull ASTNode node) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DocStringUtil.$$$reportNull$$$0(7);
        }
        StructuredDocString structuredDocString = DocStringParser.parseDocString((DocStringFormat)format, (String)node.getText());
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(8);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocStringContent(@NotNull DocStringFormat format, @NotNull String stringContent) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(9);
        }
        if (stringContent == null) {
            DocStringUtil.$$$reportNull$$$0(10);
        }
        StructuredDocString structuredDocString = DocStringParser.parseDocString((DocStringFormat)format, (Substring)new Substring(stringContent));
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(11);
        }
        return structuredDocString;
    }

    @Nullable
    public static PyStringLiteralExpression findDocStringExpression(@Nullable PyElement parent) {
        return (PyStringLiteralExpression)DocStringUtilCore.findDocStringExpression((PyAstElement)parent);
    }

    @Nullable
    public static StructuredDocString getStructuredDocString(@NotNull PyDocStringOwner owner) {
        String value;
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(12);
        }
        return (value = owner.getDocStringValue()) == null ? null : DocStringUtil.parse(value, (PsiElement)owner);
    }

    @Nullable
    public static PyStringLiteralExpression getParentDefinitionDocString(@NotNull PsiElement element) {
        if (element == null) {
            DocStringUtil.$$$reportNull$$$0(13);
        }
        return (PyStringLiteralExpression)DocStringUtilCore.getParentDefinitionDocString((PsiElement)element);
    }

    public static boolean isDocStringExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            DocStringUtil.$$$reportNull$$$0(14);
        }
        if (DocStringUtil.getParentDefinitionDocString((PsiElement)expression) == expression) {
            return true;
        }
        if (expression instanceof PyStringLiteralExpression) {
            return DocStringUtil.isVariableDocString((PyStringLiteralExpression)expression);
        }
        return false;
    }

    @Nullable
    public static String getAttributeDocComment(@NotNull PyTargetExpression attr) {
        PyAssignmentStatement assignment;
        PsiElement prevSibling;
        PsiElement psiElement;
        if (attr == null) {
            DocStringUtil.$$$reportNull$$$0(15);
        }
        if ((psiElement = attr.getParent()) instanceof PyAssignmentStatement && (prevSibling = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)(assignment = (PyAssignmentStatement)psiElement))) instanceof PsiComment && prevSibling.getText().startsWith("#:")) {
            return prevSibling.getText().substring(2);
        }
        return null;
    }

    public static boolean isVariableDocString(@NotNull PyStringLiteralExpression expr) {
        PsiElement parent;
        if (expr == null) {
            DocStringUtil.$$$reportNull$$$0(16);
        }
        if (!((parent = expr.getParent()) instanceof PyExpressionStatement)) {
            return false;
        }
        PsiElement prevElement = PyPsiUtils.getPrevNonCommentSibling((PsiElement)parent, (boolean)true);
        if (prevElement instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)prevElement;
            if (expr.getText().contains("type:")) {
                return true;
            }
            ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)prevElement, ScopeOwner.class);
            if (scope instanceof PyClass || scope instanceof PyFile) {
                return true;
            }
            if (scope instanceof PyFunction) {
                for (PyExpression target : assignmentStatement.getTargets()) {
                    if (!PyUtil.isInstanceAttribute(target)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringContent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocStringContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseDocString";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseDocStringContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStructuredDocString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentDefinitionDocString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDocStringExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDocComment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDocString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11 -> new IllegalStateException(string);
        };
    }
}

