/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import java.util.LinkedList;

public class TLSPoodleCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "tls_poodle";
    @ParametersDelegate
    private ClientDelegate clientDelegate = new ClientDelegate();
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate = new CiphersuiteDelegate();
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate = new ProtocolVersionDelegate();
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate = new StarttlsDelegate();

    public TLSPoodleCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.starttlsDelegate);
    }

    @Override
    public boolean isExecuteAttack() {
        return false;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        if (this.ciphersuiteDelegate.getCipherSuites() == null) {
            LinkedList cipherSuites = new LinkedList();
            cipherSuites.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA256);
            config.setDefaultClientSupportedCiphersuites(cipherSuites);
        }
        for (CipherSuite suite : config.getDefaultClientSupportedCiphersuites()) {
            if (suite.isCBC()) continue;
            throw new ConfigurationException("This attack only works with CBC Ciphersuites");
        }
        config.setStopActionsAfterFatal(true);
        config.setQuickReceive(true);
        config.setEarlyStop(true);
        config.setAddRenegotiationInfoExtension(true);
        config.setAddServerNameIndicationExtension(true);
        config.setAddSignatureAndHashAlgorithmsExtension(true);
        config.setQuickReceive(true);
        config.setStopActionsAfterFatal(true);
        config.setStopReceivingAfterFatal(true);
        config.setEarlyStop(true);
        boolean containsEc = false;
        for (CipherSuite suite : config.getDefaultClientSupportedCiphersuites()) {
            KeyExchangeAlgorithm keyExchangeAlgorithm = AlgorithmResolver.getKeyExchangeAlgorithm(suite);
            if (keyExchangeAlgorithm == null || !keyExchangeAlgorithm.name().toUpperCase().contains("EC")) continue;
            containsEc = true;
            break;
        }
        config.setAddECPointFormatExtension(containsEc);
        config.setAddEllipticCurveExtension(containsEc);
        return config;
    }
}

