/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.command;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.traccar.command.CommandSender;
import org.traccar.command.FindHubCommandSender;
import org.traccar.command.FirebaseCommandSender;
import org.traccar.command.TraccarCommandSender;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Device;

@Singleton
public class CommandSenderManager {
    private static final Map<String, Class<? extends CommandSender>> SENDERS_ALL = Map.of("firebase", FirebaseCommandSender.class, "traccar", TraccarCommandSender.class, "findHub", FindHubCommandSender.class);
    private final Config config;
    private final Injector injector;

    @Inject
    public CommandSenderManager(Config config, Injector injector) {
        this.config = config;
        this.injector = injector;
    }

    public CommandSender getSender(Device device) {
        String senderType = device.getString(Keys.COMMAND_SENDER.getKey());
        if (senderType != null) {
            return (CommandSender)this.injector.getInstance(SENDERS_ALL.get(senderType));
        }
        if (device.hasAttribute("notificationTokens")) {
            if (this.config.hasKey(Keys.COMMAND_CLIENT_SERVICE_ACCOUNT)) {
                return (CommandSender)this.injector.getInstance(FirebaseCommandSender.class);
            }
            if (this.config.hasKey(Keys.NOTIFICATOR_TRACCAR_KEY)) {
                return (CommandSender)this.injector.getInstance(TraccarCommandSender.class);
            }
        }
        return null;
    }
}

