/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.Utils;

public class GenerateDocumentation {
    private static final File STRING_DIRECTORY = new File("data/strings");
    private static final File RESOURCE_DIRECTORY = new File("data/default");
    private static final File RULE_DIRECTORY = new File("data/rules/classic");
    private static final String XSL = "specification.xsl";
    private static final File DESTINATION_DIRECTORY = new File("doc");
    private static final Map<String, String> resources = new HashMap<String, String>();
    private static final String[] sourceFiles = STRING_DIRECTORY.list(new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.matches("FreeColMessages.*\\.properties");
        }
    });

    public static void main(String[] args) {
        System.setProperty("jaxp.debug", "1");
        if (args.length > 0) {
            Arrays.sort(args);
        }
        GenerateDocumentation.readResources();
        GenerateDocumentation.generateDocumentation(args);
    }

    private static void readResources() {
        System.out.println("Processing source file: resources.properties");
        File sourceFile = new File(RESOURCE_DIRECTORY, "resources.properties");
        try (Reader reader = Utils.getFileUTF8Reader(sourceFile);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    resources.put(key, value);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException ioe) {
            System.err.println("Error reading resources: " + ioe);
        }
    }

    private static void generateDocumentation(String[] languages) {
        for (String name : sourceFiles) {
            String languageCode = name.substring(15, name.length() - 11);
            if (languageCode.isEmpty()) {
                languageCode = "en";
            } else {
                if ('_' != languageCode.charAt(0)) continue;
                if ("qqq".equals(languageCode = languageCode.substring(1))) {
                    System.out.println("Skipping language code 'qqq'");
                    continue;
                }
            }
            if (languages.length != 0 && Arrays.binarySearch(languages, languageCode) < 0) continue;
            System.out.println("Generating localized documentation for language code " + languageCode);
            Messages.loadMessageBundle(Messages.getLocale(languageCode));
            try {
                Transformer stylesheet;
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                StreamSource xsl = new StreamSource(new File("doc", XSL));
                try {
                    stylesheet = factory.newTransformer(xsl);
                }
                catch (TransformerException tce) {
                    System.err.println("Problem with specification.xsl at: " + tce.getLocationAsString() + "\n" + tce);
                    continue;
                }
                StreamSource request = new StreamSource(new File(RULE_DIRECTORY, "specification.xml"));
                StreamResult response = new StreamResult(new File(DESTINATION_DIRECTORY, "specification_" + languageCode + ".html"));
                stylesheet.transform(request, response);
            }
            catch (TransformerException e) {
                System.err.println("Transformation error: " + e);
            }
        }
    }

    public static String getResource(String key) {
        String[] options = new String[]{null, null, "icon", "flavor", "tileitem"};
        Object ourKey = key;
        String[] splitKey = key.split("\\.");
        String found = resources.get(ourKey);
        if (found == null && splitKey.length > 2 && "model".equals(splitKey[0])) {
            String suffix = "tile".equals(splitKey[1]) ? ".center" : "";
            options[0] = splitKey[1];
            options[1] = splitKey[1] + "icon";
            for (String x : options) {
                ourKey = "image." + x + "." + key + suffix;
                found = resources.get(ourKey);
                if (found == null) continue;
                String resourcePrefix = "resource:";
                if (!found.startsWith("resource:")) break;
                found = resources.get(found.substring("resource:".length()));
                break;
            }
        }
        return found;
    }

    public static String localize(String template) {
        return Messages.message(template);
    }

    public static String localize(String template, String key, String number) {
        double num = Double.parseDouble(number);
        Object stringTemplate = StringTemplate.template(template).addAmount(key, num);
        return Messages.message(stringTemplate);
    }
}

